/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 AngeloGioacchino Del Regno <angelogioacchino.delregno@collabora.com>
 */

#ifndef __MFD_MT6331_CORE_H__
#define __MFD_MT6331_CORE_H__

enum mt6331_irq_status_numbers {
	MT6331_IRQ_STATUS_PWRKEY = 0,
	MT6331_IRQ_STATUS_HOMEKEY,
	MT6331_IRQ_STATUS_CHRDET,
	MT6331_IRQ_STATUS_THR_H,
	MT6331_IRQ_STATUS_THR_L,
	MT6331_IRQ_STATUS_BAT_H,
	MT6331_IRQ_STATUS_BAT_L,
	MT6331_IRQ_STATUS_RTC,
	MT6331_IRQ_STATUS_AUDIO,
	MT6331_IRQ_STATUS_MAD,
	MT6331_IRQ_STATUS_ACCDET,
	MT6331_IRQ_STATUS_ACCDET_EINT,
	MT6331_IRQ_STATUS_ACCDET_NEGV = 12,
	MT6331_IRQ_STATUS_VDVFS11_OC = 16,
	MT6331_IRQ_STATUS_VDVFS12_OC,
	MT6331_IRQ_STATUS_VDVFS13_OC,
	MT6331_IRQ_STATUS_VDVFS14_OC,
	MT6331_IRQ_STATUS_GPU_OC,
	MT6331_IRQ_STATUS_VCORE1_OC,
	MT6331_IRQ_STATUS_VCORE2_OC,
	MT6331_IRQ_STATUS_VIO18_OC,
	MT6331_IRQ_STATUS_LDO_OC,
	MT6331_IRQ_STATUS_NR,
};

#define MT6331_IRQ_CON0_BASE	MT6331_IRQ_STATUS_PWRKEY
#define MT6331_IRQ_CON0_BITS	(MT6331_IRQ_STATUS_ACCDET_NEGV + 1)
#define MT6331_IRQ_CON1_BASE	MT6331_IRQ_STATUS_VDVFS11_OC
#define MT6331_IRQ_CON1_BITS	(MT6331_IRQ_STATUS_LDO_OC - MT6331_IRQ_STATUS_VDFS11_OC + 1)

#endif /* __MFD_MT6331_CORE_H__ */
