# ./play.it puzzle games collection

The codebase is maintained at [https://git.dotslashplay.it/games-puzzle/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-puzzle/]: https://git.dotslashplay.it/games-puzzle/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only puzzle games. These games focus on problem solving, most of the time puzzles based on logic. Games included in this collection should not require fast play, so timed puzzles and arcade-like puzzle games can not be found here.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for this ./play.it collection, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-puzzle play.it-puzzle.git
cd play.it-puzzle.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/scripts/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-puzzle
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- A Good Snowman is Hard to Build
- A Monster's Expedition
- A Place Full of Cats series:
    - A Building Full of Cats
    - A Castle Full of Cats
    - A Tower Full of Cats
- A Tiny Sticker Tale
- A Virus Named Tom
- A Wish Upon a Star
- About Love, Hate and the Other Ones
- Affinity
- Antichamber
- Arrow
- Arrow Patterns
- Baba Is You
- Back to Bed
- Besiege
- BIT RAT: Singularity
- Candle
- Card City Nights
- Cats Hidden in places series:
    - Cats Hidden in Bali
    - Cats Hidden in Italy
    - Cats Hidden in Maple Hollow
    - Cats Hidden in Paris
    - Cats Hidden in Georgia
- Cloud Gardens
- Codemancer
- Contraption Maker
- Cotrio
- Cosmic Express
- Crime O'Clock
- Cube Escape
- Death's Life
- Donut County
- Doodle God
- Doors: Paradox
- Down in Bermuda
- Dr Livingstone, I Presume?
- Dracula: Love Kills
- Eets Munchies
- else Heart.Break()
- English Country Tune
- Enigmatis series:
    - Enigmatis 1: The Ghosts of Maple Creek
    - Enigmatis 2: The Mists of Ravenwood
    - Enigmatis 3: The Shadow of Karkhala
- Faerie Solitaire:
    - Faerie Solitaire Harvest
    - Faerie Solitaire Remastered
- Filament
- Fill Multicolor
- Flux Caves
- Fragments of Euclid
- Fugue
- Garden In
- Gnog
- Gorogoa
- Grim Legends series:
    - Grim Legends 1: The Forsaken Bride
    - Grim Legends 2: Song of the Dark Swan
    - Grim Legends 3: The Dark City
- Helltaker
- Her Story
- Hidden Paws
- Hidden Through Time series:
    - Hidden Through Time
    - Hidden Through Time 2: Myths & Magic
- HuniePop
- inbento
- Infinifactory
- Interrogation: You Will Be Deceived
- Kerbal Space Program
- Lake Ridden
- Links Puzzle
- Lumino City
- Lumo
- Luna
- Lyne
- Lynn, The Girl Drawn On Puzzles
- Mind: Path to Thalamus
- Mini Metro
- Morphopolis
- MouseCraft
- Murder by Numbers
- Murder Mystery Machine
- Museum of Mechanics: Lockpicking
- My Brother Rabbit
- Myths Of Orion: Light From The North
- Nightmares From the Deep series:
    - Nightmares From the Deep 1: The Cursed Heart
    - Nightmares From the Deep 2: The Siren's Call
    - Nightmares From the Deep 3: Davy Jones
- One Action Heroes
- OneShot
- Pan-Pan
- Panmorphia
- Papers, Please
- Pavilion
- Pixross
- Plant Daddy
- Please Fix the Road
- Poly Bridge
- Puzzle Agent series:
    - Puzzle Agent
    - Puzzle Agent 2
- Q.U.B.E. series:
    - Q.U.B.E.
    - Q.U.B.E. 2
- Quench
- Quiet as a Stone
- Regency Solitaire
- Rime
- Rusty Lake series:
    - Rusty Lake Hotel
    - Rusty Lake Paradise
    - Rusty Lake Roots
- Save Room - Organization Puzzle
- Shenzhen I/O
- Sherlock Holmes and the Hound of the Baskervilles
- Six Cats Under
- SpaceChem
- Spring Falls
- Stacking
- Sticky Business
- Strange Horticulture
- Sudocats
- Superliminal
- Tetrobot series:
    - Blocks That Matter
    - Tetrobot and Co.
- The Adventures of Wolf and Hood - A Jigsaw Tale
- The Bridge
- The Cat Machine
- The House of Da Vinci
- The Incredible Machine series:
    - The Even More Incredible Machine
    - Return of the Incredible Machine: Contraptions
- The Inheritance of Crimson Manor
- The Pedestrian
- The Search
- The Sexy Brutale
- The Sojourn
- The Spirit and the Mouse
- The Swapper
- The Talos Principle
- The Tiny Bang Story
- The Witness
- The World Next Door
- There Is No Game: Wrong Dimension
- Tidalis
- Timelie
- TIS-100
- Townscaper
- TRI: Of Friendship and Madness
- Under Leaves
- Unmechanical
- Untitled Cat Unboxing
- Wayward Manor
- Where Is My Heart
- while True: learn()
- Windosill
- Zodiacats

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.
