// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file arrays.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__ARRAYS_HPP
#define FAST_DDS_GENERATED__ARRAYS_HPP

#include <array>
#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ARRAYS_SOURCE)
#define ARRAYS_DllAPI __declspec( dllexport )
#else
#define ARRAYS_DllAPI __declspec( dllimport )
#endif // ARRAYS_SOURCE
#else
#define ARRAYS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ARRAYS_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure ArrayShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayShort that will be copied.
     */
    eProsima_user_DllExport ArrayShort(
            const ArrayShort& x)
    {
                    m_var_array_short = x.m_var_array_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayShort that will be copied.
     */
    eProsima_user_DllExport ArrayShort(
            ArrayShort&& x) noexcept
    {
        m_var_array_short = std::move(x.m_var_array_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayShort that will be copied.
     */
    eProsima_user_DllExport ArrayShort& operator =(
            const ArrayShort& x)
    {

                    m_var_array_short = x.m_var_array_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayShort that will be copied.
     */
    eProsima_user_DllExport ArrayShort& operator =(
            ArrayShort&& x) noexcept
    {

        m_var_array_short = std::move(x.m_var_array_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayShort& x) const
    {
        return (m_var_array_short == x.m_var_array_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short
     * @param _var_array_short New value to be copied in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            const std::array<int16_t, 10>& _var_array_short)
    {
        m_var_array_short = _var_array_short;
    }

    /*!
     * @brief This function moves the value in member var_array_short
     * @param _var_array_short New value to be moved in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            std::array<int16_t, 10>&& _var_array_short)
    {
        m_var_array_short = std::move(_var_array_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short
     * @return Constant reference to member var_array_short
     */
    eProsima_user_DllExport const std::array<int16_t, 10>& var_array_short() const
    {
        return m_var_array_short;
    }

    /*!
     * @brief This function returns a reference to member var_array_short
     * @return Reference to member var_array_short
     */
    eProsima_user_DllExport std::array<int16_t, 10>& var_array_short()
    {
        return m_var_array_short;
    }



private:

    std::array<int16_t, 10> m_var_array_short{0};

};
/*!
 * @brief This class represents the structure ArrayUShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayUShort that will be copied.
     */
    eProsima_user_DllExport ArrayUShort(
            const ArrayUShort& x)
    {
                    m_var_array_ushort = x.m_var_array_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayUShort that will be copied.
     */
    eProsima_user_DllExport ArrayUShort(
            ArrayUShort&& x) noexcept
    {
        m_var_array_ushort = std::move(x.m_var_array_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayUShort that will be copied.
     */
    eProsima_user_DllExport ArrayUShort& operator =(
            const ArrayUShort& x)
    {

                    m_var_array_ushort = x.m_var_array_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayUShort that will be copied.
     */
    eProsima_user_DllExport ArrayUShort& operator =(
            ArrayUShort&& x) noexcept
    {

        m_var_array_ushort = std::move(x.m_var_array_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayUShort& x) const
    {
        return (m_var_array_ushort == x.m_var_array_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ushort
     * @param _var_array_ushort New value to be copied in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            const std::array<uint16_t, 10>& _var_array_ushort)
    {
        m_var_array_ushort = _var_array_ushort;
    }

    /*!
     * @brief This function moves the value in member var_array_ushort
     * @param _var_array_ushort New value to be moved in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            std::array<uint16_t, 10>&& _var_array_ushort)
    {
        m_var_array_ushort = std::move(_var_array_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ushort
     * @return Constant reference to member var_array_ushort
     */
    eProsima_user_DllExport const std::array<uint16_t, 10>& var_array_ushort() const
    {
        return m_var_array_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_array_ushort
     * @return Reference to member var_array_ushort
     */
    eProsima_user_DllExport std::array<uint16_t, 10>& var_array_ushort()
    {
        return m_var_array_ushort;
    }



private:

    std::array<uint16_t, 10> m_var_array_ushort{0};

};
/*!
 * @brief This class represents the structure ArrayLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayLong that will be copied.
     */
    eProsima_user_DllExport ArrayLong(
            const ArrayLong& x)
    {
                    m_var_array_long = x.m_var_array_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayLong that will be copied.
     */
    eProsima_user_DllExport ArrayLong(
            ArrayLong&& x) noexcept
    {
        m_var_array_long = std::move(x.m_var_array_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayLong that will be copied.
     */
    eProsima_user_DllExport ArrayLong& operator =(
            const ArrayLong& x)
    {

                    m_var_array_long = x.m_var_array_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayLong that will be copied.
     */
    eProsima_user_DllExport ArrayLong& operator =(
            ArrayLong&& x) noexcept
    {

        m_var_array_long = std::move(x.m_var_array_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayLong& x) const
    {
        return (m_var_array_long == x.m_var_array_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_long
     * @param _var_array_long New value to be copied in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            const std::array<int32_t, 10>& _var_array_long)
    {
        m_var_array_long = _var_array_long;
    }

    /*!
     * @brief This function moves the value in member var_array_long
     * @param _var_array_long New value to be moved in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            std::array<int32_t, 10>&& _var_array_long)
    {
        m_var_array_long = std::move(_var_array_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_long
     * @return Constant reference to member var_array_long
     */
    eProsima_user_DllExport const std::array<int32_t, 10>& var_array_long() const
    {
        return m_var_array_long;
    }

    /*!
     * @brief This function returns a reference to member var_array_long
     * @return Reference to member var_array_long
     */
    eProsima_user_DllExport std::array<int32_t, 10>& var_array_long()
    {
        return m_var_array_long;
    }



private:

    std::array<int32_t, 10> m_var_array_long{0};

};
/*!
 * @brief This class represents the structure ArrayULong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayULong that will be copied.
     */
    eProsima_user_DllExport ArrayULong(
            const ArrayULong& x)
    {
                    m_var_array_ulong = x.m_var_array_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayULong that will be copied.
     */
    eProsima_user_DllExport ArrayULong(
            ArrayULong&& x) noexcept
    {
        m_var_array_ulong = std::move(x.m_var_array_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayULong that will be copied.
     */
    eProsima_user_DllExport ArrayULong& operator =(
            const ArrayULong& x)
    {

                    m_var_array_ulong = x.m_var_array_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayULong that will be copied.
     */
    eProsima_user_DllExport ArrayULong& operator =(
            ArrayULong&& x) noexcept
    {

        m_var_array_ulong = std::move(x.m_var_array_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayULong& x) const
    {
        return (m_var_array_ulong == x.m_var_array_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulong
     * @param _var_array_ulong New value to be copied in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            const std::array<uint32_t, 10>& _var_array_ulong)
    {
        m_var_array_ulong = _var_array_ulong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulong
     * @param _var_array_ulong New value to be moved in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            std::array<uint32_t, 10>&& _var_array_ulong)
    {
        m_var_array_ulong = std::move(_var_array_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulong
     * @return Constant reference to member var_array_ulong
     */
    eProsima_user_DllExport const std::array<uint32_t, 10>& var_array_ulong() const
    {
        return m_var_array_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulong
     * @return Reference to member var_array_ulong
     */
    eProsima_user_DllExport std::array<uint32_t, 10>& var_array_ulong()
    {
        return m_var_array_ulong;
    }



private:

    std::array<uint32_t, 10> m_var_array_ulong{0};

};
/*!
 * @brief This class represents the structure ArrayLongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayLongLong(
            const ArrayLongLong& x)
    {
                    m_var_array_longlong = x.m_var_array_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayLongLong(
            ArrayLongLong&& x) noexcept
    {
        m_var_array_longlong = std::move(x.m_var_array_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayLongLong& operator =(
            const ArrayLongLong& x)
    {

                    m_var_array_longlong = x.m_var_array_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayLongLong& operator =(
            ArrayLongLong&& x) noexcept
    {

        m_var_array_longlong = std::move(x.m_var_array_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayLongLong& x) const
    {
        return (m_var_array_longlong == x.m_var_array_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longlong
     * @param _var_array_longlong New value to be copied in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            const std::array<int64_t, 10>& _var_array_longlong)
    {
        m_var_array_longlong = _var_array_longlong;
    }

    /*!
     * @brief This function moves the value in member var_array_longlong
     * @param _var_array_longlong New value to be moved in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            std::array<int64_t, 10>&& _var_array_longlong)
    {
        m_var_array_longlong = std::move(_var_array_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longlong
     * @return Constant reference to member var_array_longlong
     */
    eProsima_user_DllExport const std::array<int64_t, 10>& var_array_longlong() const
    {
        return m_var_array_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_array_longlong
     * @return Reference to member var_array_longlong
     */
    eProsima_user_DllExport std::array<int64_t, 10>& var_array_longlong()
    {
        return m_var_array_longlong;
    }



private:

    std::array<int64_t, 10> m_var_array_longlong{0};

};
/*!
 * @brief This class represents the structure ArrayULongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayULongLong(
            const ArrayULongLong& x)
    {
                    m_var_array_ulonglong = x.m_var_array_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayULongLong(
            ArrayULongLong&& x) noexcept
    {
        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayULongLong& operator =(
            const ArrayULongLong& x)
    {

                    m_var_array_ulonglong = x.m_var_array_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayULongLong& operator =(
            ArrayULongLong&& x) noexcept
    {

        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayULongLong& x) const
    {
        return (m_var_array_ulonglong == x.m_var_array_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be copied in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            const std::array<uint64_t, 10>& _var_array_ulonglong)
    {
        m_var_array_ulonglong = _var_array_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be moved in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            std::array<uint64_t, 10>&& _var_array_ulonglong)
    {
        m_var_array_ulonglong = std::move(_var_array_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulonglong
     * @return Constant reference to member var_array_ulonglong
     */
    eProsima_user_DllExport const std::array<uint64_t, 10>& var_array_ulonglong() const
    {
        return m_var_array_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulonglong
     * @return Reference to member var_array_ulonglong
     */
    eProsima_user_DllExport std::array<uint64_t, 10>& var_array_ulonglong()
    {
        return m_var_array_ulonglong;
    }



private:

    std::array<uint64_t, 10> m_var_array_ulonglong{0};

};
/*!
 * @brief This class represents the structure ArrayFloat defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayFloat that will be copied.
     */
    eProsima_user_DllExport ArrayFloat(
            const ArrayFloat& x)
    {
                    m_var_array_float = x.m_var_array_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayFloat that will be copied.
     */
    eProsima_user_DllExport ArrayFloat(
            ArrayFloat&& x) noexcept
    {
        m_var_array_float = std::move(x.m_var_array_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayFloat that will be copied.
     */
    eProsima_user_DllExport ArrayFloat& operator =(
            const ArrayFloat& x)
    {

                    m_var_array_float = x.m_var_array_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayFloat that will be copied.
     */
    eProsima_user_DllExport ArrayFloat& operator =(
            ArrayFloat&& x) noexcept
    {

        m_var_array_float = std::move(x.m_var_array_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayFloat& x) const
    {
        return (m_var_array_float == x.m_var_array_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_float
     * @param _var_array_float New value to be copied in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            const std::array<float, 10>& _var_array_float)
    {
        m_var_array_float = _var_array_float;
    }

    /*!
     * @brief This function moves the value in member var_array_float
     * @param _var_array_float New value to be moved in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            std::array<float, 10>&& _var_array_float)
    {
        m_var_array_float = std::move(_var_array_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_float
     * @return Constant reference to member var_array_float
     */
    eProsima_user_DllExport const std::array<float, 10>& var_array_float() const
    {
        return m_var_array_float;
    }

    /*!
     * @brief This function returns a reference to member var_array_float
     * @return Reference to member var_array_float
     */
    eProsima_user_DllExport std::array<float, 10>& var_array_float()
    {
        return m_var_array_float;
    }



private:

    std::array<float, 10> m_var_array_float{0.0};

};
/*!
 * @brief This class represents the structure ArrayDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayDouble that will be copied.
     */
    eProsima_user_DllExport ArrayDouble(
            const ArrayDouble& x)
    {
                    m_var_array_double = x.m_var_array_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayDouble that will be copied.
     */
    eProsima_user_DllExport ArrayDouble(
            ArrayDouble&& x) noexcept
    {
        m_var_array_double = std::move(x.m_var_array_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayDouble that will be copied.
     */
    eProsima_user_DllExport ArrayDouble& operator =(
            const ArrayDouble& x)
    {

                    m_var_array_double = x.m_var_array_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayDouble that will be copied.
     */
    eProsima_user_DllExport ArrayDouble& operator =(
            ArrayDouble&& x) noexcept
    {

        m_var_array_double = std::move(x.m_var_array_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayDouble& x) const
    {
        return (m_var_array_double == x.m_var_array_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_double
     * @param _var_array_double New value to be copied in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            const std::array<double, 10>& _var_array_double)
    {
        m_var_array_double = _var_array_double;
    }

    /*!
     * @brief This function moves the value in member var_array_double
     * @param _var_array_double New value to be moved in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            std::array<double, 10>&& _var_array_double)
    {
        m_var_array_double = std::move(_var_array_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_double
     * @return Constant reference to member var_array_double
     */
    eProsima_user_DllExport const std::array<double, 10>& var_array_double() const
    {
        return m_var_array_double;
    }

    /*!
     * @brief This function returns a reference to member var_array_double
     * @return Reference to member var_array_double
     */
    eProsima_user_DllExport std::array<double, 10>& var_array_double()
    {
        return m_var_array_double;
    }



private:

    std::array<double, 10> m_var_array_double{0.0};

};
/*!
 * @brief This class represents the structure ArrayLongDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayLongDouble(
            const ArrayLongDouble& x)
    {
                    m_var_array_longdouble = x.m_var_array_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayLongDouble(
            ArrayLongDouble&& x) noexcept
    {
        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayLongDouble& operator =(
            const ArrayLongDouble& x)
    {

                    m_var_array_longdouble = x.m_var_array_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayLongDouble& operator =(
            ArrayLongDouble&& x) noexcept
    {

        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayLongDouble& x) const
    {
        return (m_var_array_longdouble == x.m_var_array_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be copied in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            const std::array<long double, 10>& _var_array_longdouble)
    {
        m_var_array_longdouble = _var_array_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be moved in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            std::array<long double, 10>&& _var_array_longdouble)
    {
        m_var_array_longdouble = std::move(_var_array_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longdouble
     * @return Constant reference to member var_array_longdouble
     */
    eProsima_user_DllExport const std::array<long double, 10>& var_array_longdouble() const
    {
        return m_var_array_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_array_longdouble
     * @return Reference to member var_array_longdouble
     */
    eProsima_user_DllExport std::array<long double, 10>& var_array_longdouble()
    {
        return m_var_array_longdouble;
    }



private:

    std::array<long double, 10> m_var_array_longdouble{0.0};

};
/*!
 * @brief This class represents the structure ArrayBoolean defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayBoolean(
            const ArrayBoolean& x)
    {
                    m_var_array_boolean = x.m_var_array_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayBoolean(
            ArrayBoolean&& x) noexcept
    {
        m_var_array_boolean = std::move(x.m_var_array_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayBoolean& operator =(
            const ArrayBoolean& x)
    {

                    m_var_array_boolean = x.m_var_array_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayBoolean& operator =(
            ArrayBoolean&& x) noexcept
    {

        m_var_array_boolean = std::move(x.m_var_array_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayBoolean& x) const
    {
        return (m_var_array_boolean == x.m_var_array_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_boolean
     * @param _var_array_boolean New value to be copied in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            const std::array<bool, 10>& _var_array_boolean)
    {
        m_var_array_boolean = _var_array_boolean;
    }

    /*!
     * @brief This function moves the value in member var_array_boolean
     * @param _var_array_boolean New value to be moved in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            std::array<bool, 10>&& _var_array_boolean)
    {
        m_var_array_boolean = std::move(_var_array_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_boolean
     * @return Constant reference to member var_array_boolean
     */
    eProsima_user_DllExport const std::array<bool, 10>& var_array_boolean() const
    {
        return m_var_array_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_array_boolean
     * @return Reference to member var_array_boolean
     */
    eProsima_user_DllExport std::array<bool, 10>& var_array_boolean()
    {
        return m_var_array_boolean;
    }



private:

    std::array<bool, 10> m_var_array_boolean{false};

};
/*!
 * @brief This class represents the structure ArrayOctet defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayOctet that will be copied.
     */
    eProsima_user_DllExport ArrayOctet(
            const ArrayOctet& x)
    {
                    m_var_array_octet = x.m_var_array_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayOctet that will be copied.
     */
    eProsima_user_DllExport ArrayOctet(
            ArrayOctet&& x) noexcept
    {
        m_var_array_octet = std::move(x.m_var_array_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayOctet that will be copied.
     */
    eProsima_user_DllExport ArrayOctet& operator =(
            const ArrayOctet& x)
    {

                    m_var_array_octet = x.m_var_array_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayOctet that will be copied.
     */
    eProsima_user_DllExport ArrayOctet& operator =(
            ArrayOctet&& x) noexcept
    {

        m_var_array_octet = std::move(x.m_var_array_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayOctet& x) const
    {
        return (m_var_array_octet == x.m_var_array_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_octet
     * @param _var_array_octet New value to be copied in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            const std::array<uint8_t, 10>& _var_array_octet)
    {
        m_var_array_octet = _var_array_octet;
    }

    /*!
     * @brief This function moves the value in member var_array_octet
     * @param _var_array_octet New value to be moved in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            std::array<uint8_t, 10>&& _var_array_octet)
    {
        m_var_array_octet = std::move(_var_array_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_octet
     * @return Constant reference to member var_array_octet
     */
    eProsima_user_DllExport const std::array<uint8_t, 10>& var_array_octet() const
    {
        return m_var_array_octet;
    }

    /*!
     * @brief This function returns a reference to member var_array_octet
     * @return Reference to member var_array_octet
     */
    eProsima_user_DllExport std::array<uint8_t, 10>& var_array_octet()
    {
        return m_var_array_octet;
    }



private:

    std::array<uint8_t, 10> m_var_array_octet{0};

};
/*!
 * @brief This class represents the structure ArrayUInt8 defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayUInt8
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayUInt8()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayUInt8()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayUInt8 that will be copied.
     */
    eProsima_user_DllExport ArrayUInt8(
            const ArrayUInt8& x)
    {
                    m_var_array_uint8 = x.m_var_array_uint8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayUInt8 that will be copied.
     */
    eProsima_user_DllExport ArrayUInt8(
            ArrayUInt8&& x) noexcept
    {
        m_var_array_uint8 = std::move(x.m_var_array_uint8);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayUInt8 that will be copied.
     */
    eProsima_user_DllExport ArrayUInt8& operator =(
            const ArrayUInt8& x)
    {

                    m_var_array_uint8 = x.m_var_array_uint8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayUInt8 that will be copied.
     */
    eProsima_user_DllExport ArrayUInt8& operator =(
            ArrayUInt8&& x) noexcept
    {

        m_var_array_uint8 = std::move(x.m_var_array_uint8);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUInt8 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayUInt8& x) const
    {
        return (m_var_array_uint8 == x.m_var_array_uint8);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUInt8 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayUInt8& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_uint8
     * @param _var_array_uint8 New value to be copied in member var_array_uint8
     */
    eProsima_user_DllExport void var_array_uint8(
            const std::array<uint8_t, 10>& _var_array_uint8)
    {
        m_var_array_uint8 = _var_array_uint8;
    }

    /*!
     * @brief This function moves the value in member var_array_uint8
     * @param _var_array_uint8 New value to be moved in member var_array_uint8
     */
    eProsima_user_DllExport void var_array_uint8(
            std::array<uint8_t, 10>&& _var_array_uint8)
    {
        m_var_array_uint8 = std::move(_var_array_uint8);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_uint8
     * @return Constant reference to member var_array_uint8
     */
    eProsima_user_DllExport const std::array<uint8_t, 10>& var_array_uint8() const
    {
        return m_var_array_uint8;
    }

    /*!
     * @brief This function returns a reference to member var_array_uint8
     * @return Reference to member var_array_uint8
     */
    eProsima_user_DllExport std::array<uint8_t, 10>& var_array_uint8()
    {
        return m_var_array_uint8;
    }



private:

    std::array<uint8_t, 10> m_var_array_uint8{0};

};
/*!
 * @brief This class represents the structure ArrayChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayChar that will be copied.
     */
    eProsima_user_DllExport ArrayChar(
            const ArrayChar& x)
    {
                    m_var_array_char = x.m_var_array_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayChar that will be copied.
     */
    eProsima_user_DllExport ArrayChar(
            ArrayChar&& x) noexcept
    {
        m_var_array_char = std::move(x.m_var_array_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayChar that will be copied.
     */
    eProsima_user_DllExport ArrayChar& operator =(
            const ArrayChar& x)
    {

                    m_var_array_char = x.m_var_array_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayChar that will be copied.
     */
    eProsima_user_DllExport ArrayChar& operator =(
            ArrayChar&& x) noexcept
    {

        m_var_array_char = std::move(x.m_var_array_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayChar& x) const
    {
        return (m_var_array_char == x.m_var_array_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_char
     * @param _var_array_char New value to be copied in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            const std::array<char, 10>& _var_array_char)
    {
        m_var_array_char = _var_array_char;
    }

    /*!
     * @brief This function moves the value in member var_array_char
     * @param _var_array_char New value to be moved in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            std::array<char, 10>&& _var_array_char)
    {
        m_var_array_char = std::move(_var_array_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_char
     * @return Constant reference to member var_array_char
     */
    eProsima_user_DllExport const std::array<char, 10>& var_array_char() const
    {
        return m_var_array_char;
    }

    /*!
     * @brief This function returns a reference to member var_array_char
     * @return Reference to member var_array_char
     */
    eProsima_user_DllExport std::array<char, 10>& var_array_char()
    {
        return m_var_array_char;
    }



private:

    std::array<char, 10> m_var_array_char{0};

};
/*!
 * @brief This class represents the structure ArrayWChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayWChar that will be copied.
     */
    eProsima_user_DllExport ArrayWChar(
            const ArrayWChar& x)
    {
                    m_var_array_wchar = x.m_var_array_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayWChar that will be copied.
     */
    eProsima_user_DllExport ArrayWChar(
            ArrayWChar&& x) noexcept
    {
        m_var_array_wchar = std::move(x.m_var_array_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayWChar that will be copied.
     */
    eProsima_user_DllExport ArrayWChar& operator =(
            const ArrayWChar& x)
    {

                    m_var_array_wchar = x.m_var_array_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayWChar that will be copied.
     */
    eProsima_user_DllExport ArrayWChar& operator =(
            ArrayWChar&& x) noexcept
    {

        m_var_array_wchar = std::move(x.m_var_array_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayWChar& x) const
    {
        return (m_var_array_wchar == x.m_var_array_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wchar
     * @param _var_array_wchar New value to be copied in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            const std::array<wchar_t, 10>& _var_array_wchar)
    {
        m_var_array_wchar = _var_array_wchar;
    }

    /*!
     * @brief This function moves the value in member var_array_wchar
     * @param _var_array_wchar New value to be moved in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            std::array<wchar_t, 10>&& _var_array_wchar)
    {
        m_var_array_wchar = std::move(_var_array_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wchar
     * @return Constant reference to member var_array_wchar
     */
    eProsima_user_DllExport const std::array<wchar_t, 10>& var_array_wchar() const
    {
        return m_var_array_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_array_wchar
     * @return Reference to member var_array_wchar
     */
    eProsima_user_DllExport std::array<wchar_t, 10>& var_array_wchar()
    {
        return m_var_array_wchar;
    }



private:

    std::array<wchar_t, 10> m_var_array_wchar{0};

};
/*!
 * @brief This class represents the structure ArrayString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayString that will be copied.
     */
    eProsima_user_DllExport ArrayString(
            const ArrayString& x)
    {
                    m_var_array_string = x.m_var_array_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayString that will be copied.
     */
    eProsima_user_DllExport ArrayString(
            ArrayString&& x) noexcept
    {
        m_var_array_string = std::move(x.m_var_array_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayString that will be copied.
     */
    eProsima_user_DllExport ArrayString& operator =(
            const ArrayString& x)
    {

                    m_var_array_string = x.m_var_array_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayString that will be copied.
     */
    eProsima_user_DllExport ArrayString& operator =(
            ArrayString&& x) noexcept
    {

        m_var_array_string = std::move(x.m_var_array_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayString& x) const
    {
        return (m_var_array_string == x.m_var_array_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_string
     * @param _var_array_string New value to be copied in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            const std::array<std::string, 10>& _var_array_string)
    {
        m_var_array_string = _var_array_string;
    }

    /*!
     * @brief This function moves the value in member var_array_string
     * @param _var_array_string New value to be moved in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            std::array<std::string, 10>&& _var_array_string)
    {
        m_var_array_string = std::move(_var_array_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_string
     * @return Constant reference to member var_array_string
     */
    eProsima_user_DllExport const std::array<std::string, 10>& var_array_string() const
    {
        return m_var_array_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_string
     * @return Reference to member var_array_string
     */
    eProsima_user_DllExport std::array<std::string, 10>& var_array_string()
    {
        return m_var_array_string;
    }



private:

    std::array<std::string, 10> m_var_array_string;

};
/*!
 * @brief This class represents the structure ArrayWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayWString that will be copied.
     */
    eProsima_user_DllExport ArrayWString(
            const ArrayWString& x)
    {
                    m_var_array_wstring = x.m_var_array_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayWString that will be copied.
     */
    eProsima_user_DllExport ArrayWString(
            ArrayWString&& x) noexcept
    {
        m_var_array_wstring = std::move(x.m_var_array_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayWString that will be copied.
     */
    eProsima_user_DllExport ArrayWString& operator =(
            const ArrayWString& x)
    {

                    m_var_array_wstring = x.m_var_array_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayWString that will be copied.
     */
    eProsima_user_DllExport ArrayWString& operator =(
            ArrayWString&& x) noexcept
    {

        m_var_array_wstring = std::move(x.m_var_array_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayWString& x) const
    {
        return (m_var_array_wstring == x.m_var_array_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wstring
     * @param _var_array_wstring New value to be copied in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            const std::array<std::wstring, 10>& _var_array_wstring)
    {
        m_var_array_wstring = _var_array_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_wstring
     * @param _var_array_wstring New value to be moved in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            std::array<std::wstring, 10>&& _var_array_wstring)
    {
        m_var_array_wstring = std::move(_var_array_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wstring
     * @return Constant reference to member var_array_wstring
     */
    eProsima_user_DllExport const std::array<std::wstring, 10>& var_array_wstring() const
    {
        return m_var_array_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_wstring
     * @return Reference to member var_array_wstring
     */
    eProsima_user_DllExport std::array<std::wstring, 10>& var_array_wstring()
    {
        return m_var_array_wstring;
    }



private:

    std::array<std::wstring, 10> m_var_array_wstring;

};
/*!
 * @brief This class represents the structure ArrayBoundedString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedString(
            const ArrayBoundedString& x)
    {
                    m_var_array_bounded_string = x.m_var_array_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedString(
            ArrayBoundedString&& x) noexcept
    {
        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedString& operator =(
            const ArrayBoundedString& x)
    {

                    m_var_array_bounded_string = x.m_var_array_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedString& operator =(
            ArrayBoundedString&& x) noexcept
    {

        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayBoundedString& x) const
    {
        return (m_var_array_bounded_string == x.m_var_array_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be copied in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            const std::array<Inner_alias_bounded_string_helper, 10>& _var_array_bounded_string)
    {
        m_var_array_bounded_string = _var_array_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be moved in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            std::array<Inner_alias_bounded_string_helper, 10>&& _var_array_bounded_string)
    {
        m_var_array_bounded_string = std::move(_var_array_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_string
     * @return Constant reference to member var_array_bounded_string
     */
    eProsima_user_DllExport const std::array<Inner_alias_bounded_string_helper, 10>& var_array_bounded_string() const
    {
        return m_var_array_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_string
     * @return Reference to member var_array_bounded_string
     */
    eProsima_user_DllExport std::array<Inner_alias_bounded_string_helper, 10>& var_array_bounded_string()
    {
        return m_var_array_bounded_string;
    }



private:

    std::array<Inner_alias_bounded_string_helper, 10> m_var_array_bounded_string;

};
/*!
 * @brief This class represents the structure ArrayBoundedWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedWString(
            const ArrayBoundedWString& x)
    {
                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedWString(
            ArrayBoundedWString&& x) noexcept
    {
        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedWString& operator =(
            const ArrayBoundedWString& x)
    {

                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayBoundedWString& operator =(
            ArrayBoundedWString&& x) noexcept
    {

        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayBoundedWString& x) const
    {
        return (m_var_array_bounded_wstring == x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be copied in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            const std::array<Inner_alias_bounded_wstring_helper, 10>& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = _var_array_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be moved in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            std::array<Inner_alias_bounded_wstring_helper, 10>&& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = std::move(_var_array_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_wstring
     * @return Constant reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport const std::array<Inner_alias_bounded_wstring_helper, 10>& var_array_bounded_wstring() const
    {
        return m_var_array_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_wstring
     * @return Reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport std::array<Inner_alias_bounded_wstring_helper, 10>& var_array_bounded_wstring()
    {
        return m_var_array_bounded_wstring;
    }



private:

    std::array<Inner_alias_bounded_wstring_helper, 10> m_var_array_bounded_wstring;

};
/*!
 * @brief This class represents the structure ArrayEnum defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayEnum that will be copied.
     */
    eProsima_user_DllExport ArrayEnum(
            const ArrayEnum& x)
    {
                    m_var_array_enum = x.m_var_array_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayEnum that will be copied.
     */
    eProsima_user_DllExport ArrayEnum(
            ArrayEnum&& x) noexcept
    {
        m_var_array_enum = std::move(x.m_var_array_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayEnum that will be copied.
     */
    eProsima_user_DllExport ArrayEnum& operator =(
            const ArrayEnum& x)
    {

                    m_var_array_enum = x.m_var_array_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayEnum that will be copied.
     */
    eProsima_user_DllExport ArrayEnum& operator =(
            ArrayEnum&& x) noexcept
    {

        m_var_array_enum = std::move(x.m_var_array_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayEnum& x) const
    {
        return (m_var_array_enum == x.m_var_array_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_enum
     * @param _var_array_enum New value to be copied in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            const std::array<InnerEnumHelper, 10>& _var_array_enum)
    {
        m_var_array_enum = _var_array_enum;
    }

    /*!
     * @brief This function moves the value in member var_array_enum
     * @param _var_array_enum New value to be moved in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            std::array<InnerEnumHelper, 10>&& _var_array_enum)
    {
        m_var_array_enum = std::move(_var_array_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_enum
     * @return Constant reference to member var_array_enum
     */
    eProsima_user_DllExport const std::array<InnerEnumHelper, 10>& var_array_enum() const
    {
        return m_var_array_enum;
    }

    /*!
     * @brief This function returns a reference to member var_array_enum
     * @return Reference to member var_array_enum
     */
    eProsima_user_DllExport std::array<InnerEnumHelper, 10>& var_array_enum()
    {
        return m_var_array_enum;
    }



private:

    std::array<InnerEnumHelper, 10> m_var_array_enum{InnerEnumHelper::ENUM_VALUE_1};

};
/*!
 * @brief This class represents the structure ArrayBitMask defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayBitMask(
            const ArrayBitMask& x)
    {
                    m_var_array_bitmask = x.m_var_array_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayBitMask(
            ArrayBitMask&& x) noexcept
    {
        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayBitMask& operator =(
            const ArrayBitMask& x)
    {

                    m_var_array_bitmask = x.m_var_array_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayBitMask& operator =(
            ArrayBitMask&& x) noexcept
    {

        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayBitMask& x) const
    {
        return (m_var_array_bitmask == x.m_var_array_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be copied in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            const std::array<InnerBitMaskHelper, 10>& _var_array_bitmask)
    {
        m_var_array_bitmask = _var_array_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be moved in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            std::array<InnerBitMaskHelper, 10>&& _var_array_bitmask)
    {
        m_var_array_bitmask = std::move(_var_array_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitmask
     * @return Constant reference to member var_array_bitmask
     */
    eProsima_user_DllExport const std::array<InnerBitMaskHelper, 10>& var_array_bitmask() const
    {
        return m_var_array_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitmask
     * @return Reference to member var_array_bitmask
     */
    eProsima_user_DllExport std::array<InnerBitMaskHelper, 10>& var_array_bitmask()
    {
        return m_var_array_bitmask;
    }



private:

    std::array<InnerBitMaskHelper, 10> m_var_array_bitmask{0};

};
/*!
 * @brief This class represents the structure ArrayAlias defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayAlias that will be copied.
     */
    eProsima_user_DllExport ArrayAlias(
            const ArrayAlias& x)
    {
                    m_var_array_alias = x.m_var_array_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayAlias that will be copied.
     */
    eProsima_user_DllExport ArrayAlias(
            ArrayAlias&& x) noexcept
    {
        m_var_array_alias = std::move(x.m_var_array_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayAlias that will be copied.
     */
    eProsima_user_DllExport ArrayAlias& operator =(
            const ArrayAlias& x)
    {

                    m_var_array_alias = x.m_var_array_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayAlias that will be copied.
     */
    eProsima_user_DllExport ArrayAlias& operator =(
            ArrayAlias&& x) noexcept
    {

        m_var_array_alias = std::move(x.m_var_array_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayAlias& x) const
    {
        return (m_var_array_alias == x.m_var_array_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_alias
     * @param _var_array_alias New value to be copied in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            const std::array<InnerAliasHelper, 10>& _var_array_alias)
    {
        m_var_array_alias = _var_array_alias;
    }

    /*!
     * @brief This function moves the value in member var_array_alias
     * @param _var_array_alias New value to be moved in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            std::array<InnerAliasHelper, 10>&& _var_array_alias)
    {
        m_var_array_alias = std::move(_var_array_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_alias
     * @return Constant reference to member var_array_alias
     */
    eProsima_user_DllExport const std::array<InnerAliasHelper, 10>& var_array_alias() const
    {
        return m_var_array_alias;
    }

    /*!
     * @brief This function returns a reference to member var_array_alias
     * @return Reference to member var_array_alias
     */
    eProsima_user_DllExport std::array<InnerAliasHelper, 10>& var_array_alias()
    {
        return m_var_array_alias;
    }



private:

    std::array<InnerAliasHelper, 10> m_var_array_alias{0};

};
/*!
 * @brief This class represents the structure ArrayShortArray defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayShortArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayShortArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayShortArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayShortArray that will be copied.
     */
    eProsima_user_DllExport ArrayShortArray(
            const ArrayShortArray& x)
    {
                    m_var_array_short_array = x.m_var_array_short_array;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayShortArray that will be copied.
     */
    eProsima_user_DllExport ArrayShortArray(
            ArrayShortArray&& x) noexcept
    {
        m_var_array_short_array = std::move(x.m_var_array_short_array);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayShortArray that will be copied.
     */
    eProsima_user_DllExport ArrayShortArray& operator =(
            const ArrayShortArray& x)
    {

                    m_var_array_short_array = x.m_var_array_short_array;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayShortArray that will be copied.
     */
    eProsima_user_DllExport ArrayShortArray& operator =(
            ArrayShortArray&& x) noexcept
    {

        m_var_array_short_array = std::move(x.m_var_array_short_array);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayShortArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayShortArray& x) const
    {
        return (m_var_array_short_array == x.m_var_array_short_array);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayShortArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayShortArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short_array
     * @param _var_array_short_array New value to be copied in member var_array_short_array
     */
    eProsima_user_DllExport void var_array_short_array(
            const std::array<std::array<int16_t, 10>, 10>& _var_array_short_array)
    {
        m_var_array_short_array = _var_array_short_array;
    }

    /*!
     * @brief This function moves the value in member var_array_short_array
     * @param _var_array_short_array New value to be moved in member var_array_short_array
     */
    eProsima_user_DllExport void var_array_short_array(
            std::array<std::array<int16_t, 10>, 10>&& _var_array_short_array)
    {
        m_var_array_short_array = std::move(_var_array_short_array);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short_array
     * @return Constant reference to member var_array_short_array
     */
    eProsima_user_DllExport const std::array<std::array<int16_t, 10>, 10>& var_array_short_array() const
    {
        return m_var_array_short_array;
    }

    /*!
     * @brief This function returns a reference to member var_array_short_array
     * @return Reference to member var_array_short_array
     */
    eProsima_user_DllExport std::array<std::array<int16_t, 10>, 10>& var_array_short_array()
    {
        return m_var_array_short_array;
    }



private:

    std::array<std::array<int16_t, 10>, 10> m_var_array_short_array{ {{0}} };

};
/*!
 * @brief This class represents the structure ArraySequence defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySequence that will be copied.
     */
    eProsima_user_DllExport ArraySequence(
            const ArraySequence& x)
    {
                    m_var_array_sequence = x.m_var_array_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySequence that will be copied.
     */
    eProsima_user_DllExport ArraySequence(
            ArraySequence&& x) noexcept
    {
        m_var_array_sequence = std::move(x.m_var_array_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySequence that will be copied.
     */
    eProsima_user_DllExport ArraySequence& operator =(
            const ArraySequence& x)
    {

                    m_var_array_sequence = x.m_var_array_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySequence that will be copied.
     */
    eProsima_user_DllExport ArraySequence& operator =(
            ArraySequence&& x) noexcept
    {

        m_var_array_sequence = std::move(x.m_var_array_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySequence& x) const
    {
        return (m_var_array_sequence == x.m_var_array_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_sequence
     * @param _var_array_sequence New value to be copied in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            const std::array<std::vector<int32_t>, 10>& _var_array_sequence)
    {
        m_var_array_sequence = _var_array_sequence;
    }

    /*!
     * @brief This function moves the value in member var_array_sequence
     * @param _var_array_sequence New value to be moved in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            std::array<std::vector<int32_t>, 10>&& _var_array_sequence)
    {
        m_var_array_sequence = std::move(_var_array_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_sequence
     * @return Constant reference to member var_array_sequence
     */
    eProsima_user_DllExport const std::array<std::vector<int32_t>, 10>& var_array_sequence() const
    {
        return m_var_array_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_array_sequence
     * @return Reference to member var_array_sequence
     */
    eProsima_user_DllExport std::array<std::vector<int32_t>, 10>& var_array_sequence()
    {
        return m_var_array_sequence;
    }



private:

    std::array<std::vector<int32_t>, 10> m_var_array_sequence;

};
/*!
 * @brief This class represents the structure ArrayMap defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMap that will be copied.
     */
    eProsima_user_DllExport ArrayMap(
            const ArrayMap& x)
    {
                    m_var_array_map = x.m_var_array_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMap that will be copied.
     */
    eProsima_user_DllExport ArrayMap(
            ArrayMap&& x) noexcept
    {
        m_var_array_map = std::move(x.m_var_array_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMap that will be copied.
     */
    eProsima_user_DllExport ArrayMap& operator =(
            const ArrayMap& x)
    {

                    m_var_array_map = x.m_var_array_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMap that will be copied.
     */
    eProsima_user_DllExport ArrayMap& operator =(
            ArrayMap&& x) noexcept
    {

        m_var_array_map = std::move(x.m_var_array_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMap& x) const
    {
        return (m_var_array_map == x.m_var_array_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_map
     * @param _var_array_map New value to be copied in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            const std::array<std::map<int32_t, int32_t>, 10>& _var_array_map)
    {
        m_var_array_map = _var_array_map;
    }

    /*!
     * @brief This function moves the value in member var_array_map
     * @param _var_array_map New value to be moved in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            std::array<std::map<int32_t, int32_t>, 10>&& _var_array_map)
    {
        m_var_array_map = std::move(_var_array_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_map
     * @return Constant reference to member var_array_map
     */
    eProsima_user_DllExport const std::array<std::map<int32_t, int32_t>, 10>& var_array_map() const
    {
        return m_var_array_map;
    }

    /*!
     * @brief This function returns a reference to member var_array_map
     * @return Reference to member var_array_map
     */
    eProsima_user_DllExport std::array<std::map<int32_t, int32_t>, 10>& var_array_map()
    {
        return m_var_array_map;
    }



private:

    std::array<std::map<int32_t, int32_t>, 10> m_var_array_map;

};
/*!
 * @brief This class represents the structure ArrayUnion defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayUnion that will be copied.
     */
    eProsima_user_DllExport ArrayUnion(
            const ArrayUnion& x)
    {
                    m_var_array_union = x.m_var_array_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayUnion that will be copied.
     */
    eProsima_user_DllExport ArrayUnion(
            ArrayUnion&& x) noexcept
    {
        m_var_array_union = std::move(x.m_var_array_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayUnion that will be copied.
     */
    eProsima_user_DllExport ArrayUnion& operator =(
            const ArrayUnion& x)
    {

                    m_var_array_union = x.m_var_array_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayUnion that will be copied.
     */
    eProsima_user_DllExport ArrayUnion& operator =(
            ArrayUnion&& x) noexcept
    {

        m_var_array_union = std::move(x.m_var_array_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayUnion& x) const
    {
        return (m_var_array_union == x.m_var_array_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_union
     * @param _var_array_union New value to be copied in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            const std::array<InnerUnionHelper, 10>& _var_array_union)
    {
        m_var_array_union = _var_array_union;
    }

    /*!
     * @brief This function moves the value in member var_array_union
     * @param _var_array_union New value to be moved in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            std::array<InnerUnionHelper, 10>&& _var_array_union)
    {
        m_var_array_union = std::move(_var_array_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_union
     * @return Constant reference to member var_array_union
     */
    eProsima_user_DllExport const std::array<InnerUnionHelper, 10>& var_array_union() const
    {
        return m_var_array_union;
    }

    /*!
     * @brief This function returns a reference to member var_array_union
     * @return Reference to member var_array_union
     */
    eProsima_user_DllExport std::array<InnerUnionHelper, 10>& var_array_union()
    {
        return m_var_array_union;
    }



private:

    std::array<InnerUnionHelper, 10> m_var_array_union;

};
/*!
 * @brief This class represents the structure ArrayStructure defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayStructure that will be copied.
     */
    eProsima_user_DllExport ArrayStructure(
            const ArrayStructure& x)
    {
                    m_var_array_structure = x.m_var_array_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayStructure that will be copied.
     */
    eProsima_user_DllExport ArrayStructure(
            ArrayStructure&& x) noexcept
    {
        m_var_array_structure = std::move(x.m_var_array_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayStructure that will be copied.
     */
    eProsima_user_DllExport ArrayStructure& operator =(
            const ArrayStructure& x)
    {

                    m_var_array_structure = x.m_var_array_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayStructure that will be copied.
     */
    eProsima_user_DllExport ArrayStructure& operator =(
            ArrayStructure&& x) noexcept
    {

        m_var_array_structure = std::move(x.m_var_array_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayStructure& x) const
    {
        return (m_var_array_structure == x.m_var_array_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_structure
     * @param _var_array_structure New value to be copied in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            const std::array<InnerStructureHelper, 10>& _var_array_structure)
    {
        m_var_array_structure = _var_array_structure;
    }

    /*!
     * @brief This function moves the value in member var_array_structure
     * @param _var_array_structure New value to be moved in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            std::array<InnerStructureHelper, 10>&& _var_array_structure)
    {
        m_var_array_structure = std::move(_var_array_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_structure
     * @return Constant reference to member var_array_structure
     */
    eProsima_user_DllExport const std::array<InnerStructureHelper, 10>& var_array_structure() const
    {
        return m_var_array_structure;
    }

    /*!
     * @brief This function returns a reference to member var_array_structure
     * @return Reference to member var_array_structure
     */
    eProsima_user_DllExport std::array<InnerStructureHelper, 10>& var_array_structure()
    {
        return m_var_array_structure;
    }



private:

    std::array<InnerStructureHelper, 10> m_var_array_structure;

};
/*!
 * @brief This class represents the structure ArrayBitset defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayBitset that will be copied.
     */
    eProsima_user_DllExport ArrayBitset(
            const ArrayBitset& x)
    {
                    m_var_array_bitset = x.m_var_array_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayBitset that will be copied.
     */
    eProsima_user_DllExport ArrayBitset(
            ArrayBitset&& x) noexcept
    {
        m_var_array_bitset = std::move(x.m_var_array_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayBitset that will be copied.
     */
    eProsima_user_DllExport ArrayBitset& operator =(
            const ArrayBitset& x)
    {

                    m_var_array_bitset = x.m_var_array_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayBitset that will be copied.
     */
    eProsima_user_DllExport ArrayBitset& operator =(
            ArrayBitset&& x) noexcept
    {

        m_var_array_bitset = std::move(x.m_var_array_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayBitset& x) const
    {
        return (m_var_array_bitset == x.m_var_array_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitset
     * @param _var_array_bitset New value to be copied in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            const std::array<InnerBitsetHelper, 10>& _var_array_bitset)
    {
        m_var_array_bitset = _var_array_bitset;
    }

    /*!
     * @brief This function moves the value in member var_array_bitset
     * @param _var_array_bitset New value to be moved in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            std::array<InnerBitsetHelper, 10>&& _var_array_bitset)
    {
        m_var_array_bitset = std::move(_var_array_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitset
     * @return Constant reference to member var_array_bitset
     */
    eProsima_user_DllExport const std::array<InnerBitsetHelper, 10>& var_array_bitset() const
    {
        return m_var_array_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitset
     * @return Reference to member var_array_bitset
     */
    eProsima_user_DllExport std::array<InnerBitsetHelper, 10>& var_array_bitset()
    {
        return m_var_array_bitset;
    }



private:

    std::array<InnerBitsetHelper, 10> m_var_array_bitset;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionShort(
            const ArrayMultiDimensionShort& x)
    {
                    m_var_array_short = x.m_var_array_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionShort(
            ArrayMultiDimensionShort&& x) noexcept
    {
        m_var_array_short = std::move(x.m_var_array_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionShort& operator =(
            const ArrayMultiDimensionShort& x)
    {

                    m_var_array_short = x.m_var_array_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionShort& operator =(
            ArrayMultiDimensionShort&& x) noexcept
    {

        m_var_array_short = std::move(x.m_var_array_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionShort& x) const
    {
        return (m_var_array_short == x.m_var_array_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short
     * @param _var_array_short New value to be copied in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            const std::array<std::array<std::array<int16_t, 10>, 10>, 10>& _var_array_short)
    {
        m_var_array_short = _var_array_short;
    }

    /*!
     * @brief This function moves the value in member var_array_short
     * @param _var_array_short New value to be moved in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            std::array<std::array<std::array<int16_t, 10>, 10>, 10>&& _var_array_short)
    {
        m_var_array_short = std::move(_var_array_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short
     * @return Constant reference to member var_array_short
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int16_t, 10>, 10>, 10>& var_array_short() const
    {
        return m_var_array_short;
    }

    /*!
     * @brief This function returns a reference to member var_array_short
     * @return Reference to member var_array_short
     */
    eProsima_user_DllExport std::array<std::array<std::array<int16_t, 10>, 10>, 10>& var_array_short()
    {
        return m_var_array_short;
    }



private:

    std::array<std::array<std::array<int16_t, 10>, 10>, 10> m_var_array_short{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionUShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUShort(
            const ArrayMultiDimensionUShort& x)
    {
                    m_var_array_ushort = x.m_var_array_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUShort(
            ArrayMultiDimensionUShort&& x) noexcept
    {
        m_var_array_ushort = std::move(x.m_var_array_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUShort& operator =(
            const ArrayMultiDimensionUShort& x)
    {

                    m_var_array_ushort = x.m_var_array_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUShort& operator =(
            ArrayMultiDimensionUShort&& x) noexcept
    {

        m_var_array_ushort = std::move(x.m_var_array_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionUShort& x) const
    {
        return (m_var_array_ushort == x.m_var_array_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ushort
     * @param _var_array_ushort New value to be copied in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            const std::array<std::array<std::array<uint16_t, 10>, 10>, 10>& _var_array_ushort)
    {
        m_var_array_ushort = _var_array_ushort;
    }

    /*!
     * @brief This function moves the value in member var_array_ushort
     * @param _var_array_ushort New value to be moved in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            std::array<std::array<std::array<uint16_t, 10>, 10>, 10>&& _var_array_ushort)
    {
        m_var_array_ushort = std::move(_var_array_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ushort
     * @return Constant reference to member var_array_ushort
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint16_t, 10>, 10>, 10>& var_array_ushort() const
    {
        return m_var_array_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_array_ushort
     * @return Reference to member var_array_ushort
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint16_t, 10>, 10>, 10>& var_array_ushort()
    {
        return m_var_array_ushort;
    }



private:

    std::array<std::array<std::array<uint16_t, 10>, 10>, 10> m_var_array_ushort{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLong(
            const ArrayMultiDimensionLong& x)
    {
                    m_var_array_long = x.m_var_array_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLong(
            ArrayMultiDimensionLong&& x) noexcept
    {
        m_var_array_long = std::move(x.m_var_array_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLong& operator =(
            const ArrayMultiDimensionLong& x)
    {

                    m_var_array_long = x.m_var_array_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLong& operator =(
            ArrayMultiDimensionLong&& x) noexcept
    {

        m_var_array_long = std::move(x.m_var_array_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLong& x) const
    {
        return (m_var_array_long == x.m_var_array_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_long
     * @param _var_array_long New value to be copied in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            const std::array<std::array<std::array<int32_t, 10>, 10>, 10>& _var_array_long)
    {
        m_var_array_long = _var_array_long;
    }

    /*!
     * @brief This function moves the value in member var_array_long
     * @param _var_array_long New value to be moved in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            std::array<std::array<std::array<int32_t, 10>, 10>, 10>&& _var_array_long)
    {
        m_var_array_long = std::move(_var_array_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_long
     * @return Constant reference to member var_array_long
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int32_t, 10>, 10>, 10>& var_array_long() const
    {
        return m_var_array_long;
    }

    /*!
     * @brief This function returns a reference to member var_array_long
     * @return Reference to member var_array_long
     */
    eProsima_user_DllExport std::array<std::array<std::array<int32_t, 10>, 10>, 10>& var_array_long()
    {
        return m_var_array_long;
    }



private:

    std::array<std::array<std::array<int32_t, 10>, 10>, 10> m_var_array_long{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionULong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULong(
            const ArrayMultiDimensionULong& x)
    {
                    m_var_array_ulong = x.m_var_array_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULong(
            ArrayMultiDimensionULong&& x) noexcept
    {
        m_var_array_ulong = std::move(x.m_var_array_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULong& operator =(
            const ArrayMultiDimensionULong& x)
    {

                    m_var_array_ulong = x.m_var_array_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULong& operator =(
            ArrayMultiDimensionULong&& x) noexcept
    {

        m_var_array_ulong = std::move(x.m_var_array_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionULong& x) const
    {
        return (m_var_array_ulong == x.m_var_array_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulong
     * @param _var_array_ulong New value to be copied in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            const std::array<std::array<std::array<uint32_t, 10>, 10>, 10>& _var_array_ulong)
    {
        m_var_array_ulong = _var_array_ulong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulong
     * @param _var_array_ulong New value to be moved in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            std::array<std::array<std::array<uint32_t, 10>, 10>, 10>&& _var_array_ulong)
    {
        m_var_array_ulong = std::move(_var_array_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulong
     * @return Constant reference to member var_array_ulong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint32_t, 10>, 10>, 10>& var_array_ulong() const
    {
        return m_var_array_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulong
     * @return Reference to member var_array_ulong
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint32_t, 10>, 10>, 10>& var_array_ulong()
    {
        return m_var_array_ulong;
    }



private:

    std::array<std::array<std::array<uint32_t, 10>, 10>, 10> m_var_array_ulong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongLong(
            const ArrayMultiDimensionLongLong& x)
    {
                    m_var_array_longlong = x.m_var_array_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongLong(
            ArrayMultiDimensionLongLong&& x) noexcept
    {
        m_var_array_longlong = std::move(x.m_var_array_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongLong& operator =(
            const ArrayMultiDimensionLongLong& x)
    {

                    m_var_array_longlong = x.m_var_array_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongLong& operator =(
            ArrayMultiDimensionLongLong&& x) noexcept
    {

        m_var_array_longlong = std::move(x.m_var_array_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLongLong& x) const
    {
        return (m_var_array_longlong == x.m_var_array_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longlong
     * @param _var_array_longlong New value to be copied in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            const std::array<std::array<std::array<int64_t, 10>, 10>, 10>& _var_array_longlong)
    {
        m_var_array_longlong = _var_array_longlong;
    }

    /*!
     * @brief This function moves the value in member var_array_longlong
     * @param _var_array_longlong New value to be moved in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            std::array<std::array<std::array<int64_t, 10>, 10>, 10>&& _var_array_longlong)
    {
        m_var_array_longlong = std::move(_var_array_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longlong
     * @return Constant reference to member var_array_longlong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int64_t, 10>, 10>, 10>& var_array_longlong() const
    {
        return m_var_array_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_array_longlong
     * @return Reference to member var_array_longlong
     */
    eProsima_user_DllExport std::array<std::array<std::array<int64_t, 10>, 10>, 10>& var_array_longlong()
    {
        return m_var_array_longlong;
    }



private:

    std::array<std::array<std::array<int64_t, 10>, 10>, 10> m_var_array_longlong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionULongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULongLong(
            const ArrayMultiDimensionULongLong& x)
    {
                    m_var_array_ulonglong = x.m_var_array_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULongLong(
            ArrayMultiDimensionULongLong&& x) noexcept
    {
        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULongLong& operator =(
            const ArrayMultiDimensionULongLong& x)
    {

                    m_var_array_ulonglong = x.m_var_array_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionULongLong& operator =(
            ArrayMultiDimensionULongLong&& x) noexcept
    {

        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionULongLong& x) const
    {
        return (m_var_array_ulonglong == x.m_var_array_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be copied in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            const std::array<std::array<std::array<uint64_t, 10>, 10>, 10>& _var_array_ulonglong)
    {
        m_var_array_ulonglong = _var_array_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be moved in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            std::array<std::array<std::array<uint64_t, 10>, 10>, 10>&& _var_array_ulonglong)
    {
        m_var_array_ulonglong = std::move(_var_array_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulonglong
     * @return Constant reference to member var_array_ulonglong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint64_t, 10>, 10>, 10>& var_array_ulonglong() const
    {
        return m_var_array_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulonglong
     * @return Reference to member var_array_ulonglong
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint64_t, 10>, 10>, 10>& var_array_ulonglong()
    {
        return m_var_array_ulonglong;
    }



private:

    std::array<std::array<std::array<uint64_t, 10>, 10>, 10> m_var_array_ulonglong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionFloat defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionFloat(
            const ArrayMultiDimensionFloat& x)
    {
                    m_var_array_float = x.m_var_array_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionFloat(
            ArrayMultiDimensionFloat&& x) noexcept
    {
        m_var_array_float = std::move(x.m_var_array_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionFloat& operator =(
            const ArrayMultiDimensionFloat& x)
    {

                    m_var_array_float = x.m_var_array_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionFloat& operator =(
            ArrayMultiDimensionFloat&& x) noexcept
    {

        m_var_array_float = std::move(x.m_var_array_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionFloat& x) const
    {
        return (m_var_array_float == x.m_var_array_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_float
     * @param _var_array_float New value to be copied in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            const std::array<std::array<std::array<float, 10>, 10>, 10>& _var_array_float)
    {
        m_var_array_float = _var_array_float;
    }

    /*!
     * @brief This function moves the value in member var_array_float
     * @param _var_array_float New value to be moved in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            std::array<std::array<std::array<float, 10>, 10>, 10>&& _var_array_float)
    {
        m_var_array_float = std::move(_var_array_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_float
     * @return Constant reference to member var_array_float
     */
    eProsima_user_DllExport const std::array<std::array<std::array<float, 10>, 10>, 10>& var_array_float() const
    {
        return m_var_array_float;
    }

    /*!
     * @brief This function returns a reference to member var_array_float
     * @return Reference to member var_array_float
     */
    eProsima_user_DllExport std::array<std::array<std::array<float, 10>, 10>, 10>& var_array_float()
    {
        return m_var_array_float;
    }



private:

    std::array<std::array<std::array<float, 10>, 10>, 10> m_var_array_float{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionDouble(
            const ArrayMultiDimensionDouble& x)
    {
                    m_var_array_double = x.m_var_array_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionDouble(
            ArrayMultiDimensionDouble&& x) noexcept
    {
        m_var_array_double = std::move(x.m_var_array_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionDouble& operator =(
            const ArrayMultiDimensionDouble& x)
    {

                    m_var_array_double = x.m_var_array_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionDouble& operator =(
            ArrayMultiDimensionDouble&& x) noexcept
    {

        m_var_array_double = std::move(x.m_var_array_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionDouble& x) const
    {
        return (m_var_array_double == x.m_var_array_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_double
     * @param _var_array_double New value to be copied in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            const std::array<std::array<std::array<double, 10>, 10>, 10>& _var_array_double)
    {
        m_var_array_double = _var_array_double;
    }

    /*!
     * @brief This function moves the value in member var_array_double
     * @param _var_array_double New value to be moved in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            std::array<std::array<std::array<double, 10>, 10>, 10>&& _var_array_double)
    {
        m_var_array_double = std::move(_var_array_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_double
     * @return Constant reference to member var_array_double
     */
    eProsima_user_DllExport const std::array<std::array<std::array<double, 10>, 10>, 10>& var_array_double() const
    {
        return m_var_array_double;
    }

    /*!
     * @brief This function returns a reference to member var_array_double
     * @return Reference to member var_array_double
     */
    eProsima_user_DllExport std::array<std::array<std::array<double, 10>, 10>, 10>& var_array_double()
    {
        return m_var_array_double;
    }



private:

    std::array<std::array<std::array<double, 10>, 10>, 10> m_var_array_double{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLongDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongDouble(
            const ArrayMultiDimensionLongDouble& x)
    {
                    m_var_array_longdouble = x.m_var_array_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongDouble(
            ArrayMultiDimensionLongDouble&& x) noexcept
    {
        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongDouble& operator =(
            const ArrayMultiDimensionLongDouble& x)
    {

                    m_var_array_longdouble = x.m_var_array_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLongDouble& operator =(
            ArrayMultiDimensionLongDouble&& x) noexcept
    {

        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLongDouble& x) const
    {
        return (m_var_array_longdouble == x.m_var_array_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be copied in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            const std::array<std::array<std::array<long double, 10>, 10>, 10>& _var_array_longdouble)
    {
        m_var_array_longdouble = _var_array_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be moved in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            std::array<std::array<std::array<long double, 10>, 10>, 10>&& _var_array_longdouble)
    {
        m_var_array_longdouble = std::move(_var_array_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longdouble
     * @return Constant reference to member var_array_longdouble
     */
    eProsima_user_DllExport const std::array<std::array<std::array<long double, 10>, 10>, 10>& var_array_longdouble() const
    {
        return m_var_array_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_array_longdouble
     * @return Reference to member var_array_longdouble
     */
    eProsima_user_DllExport std::array<std::array<std::array<long double, 10>, 10>, 10>& var_array_longdouble()
    {
        return m_var_array_longdouble;
    }



private:

    std::array<std::array<std::array<long double, 10>, 10>, 10> m_var_array_longdouble{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionBoolean defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoolean(
            const ArrayMultiDimensionBoolean& x)
    {
                    m_var_array_boolean = x.m_var_array_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoolean(
            ArrayMultiDimensionBoolean&& x) noexcept
    {
        m_var_array_boolean = std::move(x.m_var_array_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoolean& operator =(
            const ArrayMultiDimensionBoolean& x)
    {

                    m_var_array_boolean = x.m_var_array_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoolean& operator =(
            ArrayMultiDimensionBoolean&& x) noexcept
    {

        m_var_array_boolean = std::move(x.m_var_array_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionBoolean& x) const
    {
        return (m_var_array_boolean == x.m_var_array_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_boolean
     * @param _var_array_boolean New value to be copied in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            const std::array<std::array<std::array<bool, 10>, 10>, 10>& _var_array_boolean)
    {
        m_var_array_boolean = _var_array_boolean;
    }

    /*!
     * @brief This function moves the value in member var_array_boolean
     * @param _var_array_boolean New value to be moved in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            std::array<std::array<std::array<bool, 10>, 10>, 10>&& _var_array_boolean)
    {
        m_var_array_boolean = std::move(_var_array_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_boolean
     * @return Constant reference to member var_array_boolean
     */
    eProsima_user_DllExport const std::array<std::array<std::array<bool, 10>, 10>, 10>& var_array_boolean() const
    {
        return m_var_array_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_array_boolean
     * @return Reference to member var_array_boolean
     */
    eProsima_user_DllExport std::array<std::array<std::array<bool, 10>, 10>, 10>& var_array_boolean()
    {
        return m_var_array_boolean;
    }



private:

    std::array<std::array<std::array<bool, 10>, 10>, 10> m_var_array_boolean{ {{ {{false}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionOctet defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionOctet(
            const ArrayMultiDimensionOctet& x)
    {
                    m_var_array_octet = x.m_var_array_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionOctet(
            ArrayMultiDimensionOctet&& x) noexcept
    {
        m_var_array_octet = std::move(x.m_var_array_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionOctet& operator =(
            const ArrayMultiDimensionOctet& x)
    {

                    m_var_array_octet = x.m_var_array_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionOctet& operator =(
            ArrayMultiDimensionOctet&& x) noexcept
    {

        m_var_array_octet = std::move(x.m_var_array_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionOctet& x) const
    {
        return (m_var_array_octet == x.m_var_array_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_octet
     * @param _var_array_octet New value to be copied in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            const std::array<std::array<std::array<uint8_t, 10>, 10>, 10>& _var_array_octet)
    {
        m_var_array_octet = _var_array_octet;
    }

    /*!
     * @brief This function moves the value in member var_array_octet
     * @param _var_array_octet New value to be moved in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            std::array<std::array<std::array<uint8_t, 10>, 10>, 10>&& _var_array_octet)
    {
        m_var_array_octet = std::move(_var_array_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_octet
     * @return Constant reference to member var_array_octet
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint8_t, 10>, 10>, 10>& var_array_octet() const
    {
        return m_var_array_octet;
    }

    /*!
     * @brief This function returns a reference to member var_array_octet
     * @return Reference to member var_array_octet
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint8_t, 10>, 10>, 10>& var_array_octet()
    {
        return m_var_array_octet;
    }



private:

    std::array<std::array<std::array<uint8_t, 10>, 10>, 10> m_var_array_octet{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionChar(
            const ArrayMultiDimensionChar& x)
    {
                    m_var_array_char = x.m_var_array_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionChar(
            ArrayMultiDimensionChar&& x) noexcept
    {
        m_var_array_char = std::move(x.m_var_array_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionChar& operator =(
            const ArrayMultiDimensionChar& x)
    {

                    m_var_array_char = x.m_var_array_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionChar& operator =(
            ArrayMultiDimensionChar&& x) noexcept
    {

        m_var_array_char = std::move(x.m_var_array_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionChar& x) const
    {
        return (m_var_array_char == x.m_var_array_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_char
     * @param _var_array_char New value to be copied in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            const std::array<std::array<std::array<char, 10>, 10>, 10>& _var_array_char)
    {
        m_var_array_char = _var_array_char;
    }

    /*!
     * @brief This function moves the value in member var_array_char
     * @param _var_array_char New value to be moved in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            std::array<std::array<std::array<char, 10>, 10>, 10>&& _var_array_char)
    {
        m_var_array_char = std::move(_var_array_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_char
     * @return Constant reference to member var_array_char
     */
    eProsima_user_DllExport const std::array<std::array<std::array<char, 10>, 10>, 10>& var_array_char() const
    {
        return m_var_array_char;
    }

    /*!
     * @brief This function returns a reference to member var_array_char
     * @return Reference to member var_array_char
     */
    eProsima_user_DllExport std::array<std::array<std::array<char, 10>, 10>, 10>& var_array_char()
    {
        return m_var_array_char;
    }



private:

    std::array<std::array<std::array<char, 10>, 10>, 10> m_var_array_char{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionWChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWChar(
            const ArrayMultiDimensionWChar& x)
    {
                    m_var_array_wchar = x.m_var_array_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWChar(
            ArrayMultiDimensionWChar&& x) noexcept
    {
        m_var_array_wchar = std::move(x.m_var_array_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWChar& operator =(
            const ArrayMultiDimensionWChar& x)
    {

                    m_var_array_wchar = x.m_var_array_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWChar& operator =(
            ArrayMultiDimensionWChar&& x) noexcept
    {

        m_var_array_wchar = std::move(x.m_var_array_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionWChar& x) const
    {
        return (m_var_array_wchar == x.m_var_array_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wchar
     * @param _var_array_wchar New value to be copied in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            const std::array<std::array<std::array<wchar_t, 10>, 10>, 10>& _var_array_wchar)
    {
        m_var_array_wchar = _var_array_wchar;
    }

    /*!
     * @brief This function moves the value in member var_array_wchar
     * @param _var_array_wchar New value to be moved in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            std::array<std::array<std::array<wchar_t, 10>, 10>, 10>&& _var_array_wchar)
    {
        m_var_array_wchar = std::move(_var_array_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wchar
     * @return Constant reference to member var_array_wchar
     */
    eProsima_user_DllExport const std::array<std::array<std::array<wchar_t, 10>, 10>, 10>& var_array_wchar() const
    {
        return m_var_array_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_array_wchar
     * @return Reference to member var_array_wchar
     */
    eProsima_user_DllExport std::array<std::array<std::array<wchar_t, 10>, 10>, 10>& var_array_wchar()
    {
        return m_var_array_wchar;
    }



private:

    std::array<std::array<std::array<wchar_t, 10>, 10>, 10> m_var_array_wchar{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionString(
            const ArrayMultiDimensionString& x)
    {
                    m_var_array_string = x.m_var_array_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionString(
            ArrayMultiDimensionString&& x) noexcept
    {
        m_var_array_string = std::move(x.m_var_array_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionString& operator =(
            const ArrayMultiDimensionString& x)
    {

                    m_var_array_string = x.m_var_array_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionString& operator =(
            ArrayMultiDimensionString&& x) noexcept
    {

        m_var_array_string = std::move(x.m_var_array_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionString& x) const
    {
        return (m_var_array_string == x.m_var_array_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_string
     * @param _var_array_string New value to be copied in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            const std::array<std::array<std::array<std::string, 10>, 10>, 10>& _var_array_string)
    {
        m_var_array_string = _var_array_string;
    }

    /*!
     * @brief This function moves the value in member var_array_string
     * @param _var_array_string New value to be moved in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            std::array<std::array<std::array<std::string, 10>, 10>, 10>&& _var_array_string)
    {
        m_var_array_string = std::move(_var_array_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_string
     * @return Constant reference to member var_array_string
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::string, 10>, 10>, 10>& var_array_string() const
    {
        return m_var_array_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_string
     * @return Reference to member var_array_string
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::string, 10>, 10>, 10>& var_array_string()
    {
        return m_var_array_string;
    }



private:

    std::array<std::array<std::array<std::string, 10>, 10>, 10> m_var_array_string;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWString(
            const ArrayMultiDimensionWString& x)
    {
                    m_var_array_wstring = x.m_var_array_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWString(
            ArrayMultiDimensionWString&& x) noexcept
    {
        m_var_array_wstring = std::move(x.m_var_array_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWString& operator =(
            const ArrayMultiDimensionWString& x)
    {

                    m_var_array_wstring = x.m_var_array_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionWString& operator =(
            ArrayMultiDimensionWString&& x) noexcept
    {

        m_var_array_wstring = std::move(x.m_var_array_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionWString& x) const
    {
        return (m_var_array_wstring == x.m_var_array_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wstring
     * @param _var_array_wstring New value to be copied in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            const std::array<std::array<std::array<std::wstring, 10>, 10>, 10>& _var_array_wstring)
    {
        m_var_array_wstring = _var_array_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_wstring
     * @param _var_array_wstring New value to be moved in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            std::array<std::array<std::array<std::wstring, 10>, 10>, 10>&& _var_array_wstring)
    {
        m_var_array_wstring = std::move(_var_array_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wstring
     * @return Constant reference to member var_array_wstring
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::wstring, 10>, 10>, 10>& var_array_wstring() const
    {
        return m_var_array_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_wstring
     * @return Reference to member var_array_wstring
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::wstring, 10>, 10>, 10>& var_array_wstring()
    {
        return m_var_array_wstring;
    }



private:

    std::array<std::array<std::array<std::wstring, 10>, 10>, 10> m_var_array_wstring;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionBoundedString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedString(
            const ArrayMultiDimensionBoundedString& x)
    {
                    m_var_array_bounded_string = x.m_var_array_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedString(
            ArrayMultiDimensionBoundedString&& x) noexcept
    {
        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedString& operator =(
            const ArrayMultiDimensionBoundedString& x)
    {

                    m_var_array_bounded_string = x.m_var_array_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedString& operator =(
            ArrayMultiDimensionBoundedString&& x) noexcept
    {

        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionBoundedString& x) const
    {
        return (m_var_array_bounded_string == x.m_var_array_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be copied in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            const std::array<std::array<std::array<Inner_alias_bounded_string_helper, 10>, 10>, 10>& _var_array_bounded_string)
    {
        m_var_array_bounded_string = _var_array_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be moved in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            std::array<std::array<std::array<Inner_alias_bounded_string_helper, 10>, 10>, 10>&& _var_array_bounded_string)
    {
        m_var_array_bounded_string = std::move(_var_array_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_string
     * @return Constant reference to member var_array_bounded_string
     */
    eProsima_user_DllExport const std::array<std::array<std::array<Inner_alias_bounded_string_helper, 10>, 10>, 10>& var_array_bounded_string() const
    {
        return m_var_array_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_string
     * @return Reference to member var_array_bounded_string
     */
    eProsima_user_DllExport std::array<std::array<std::array<Inner_alias_bounded_string_helper, 10>, 10>, 10>& var_array_bounded_string()
    {
        return m_var_array_bounded_string;
    }



private:

    std::array<std::array<std::array<Inner_alias_bounded_string_helper, 10>, 10>, 10> m_var_array_bounded_string;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionBoundedWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedWString(
            const ArrayMultiDimensionBoundedWString& x)
    {
                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedWString(
            ArrayMultiDimensionBoundedWString&& x) noexcept
    {
        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedWString& operator =(
            const ArrayMultiDimensionBoundedWString& x)
    {

                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBoundedWString& operator =(
            ArrayMultiDimensionBoundedWString&& x) noexcept
    {

        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionBoundedWString& x) const
    {
        return (m_var_array_bounded_wstring == x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be copied in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            const std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 10>, 10>, 10>& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = _var_array_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be moved in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 10>, 10>, 10>&& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = std::move(_var_array_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_wstring
     * @return Constant reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport const std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 10>, 10>, 10>& var_array_bounded_wstring() const
    {
        return m_var_array_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_wstring
     * @return Reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 10>, 10>, 10>& var_array_bounded_wstring()
    {
        return m_var_array_bounded_wstring;
    }



private:

    std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 10>, 10>, 10> m_var_array_bounded_wstring;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionEnum defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionEnum(
            const ArrayMultiDimensionEnum& x)
    {
                    m_var_array_enum = x.m_var_array_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionEnum(
            ArrayMultiDimensionEnum&& x) noexcept
    {
        m_var_array_enum = std::move(x.m_var_array_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionEnum& operator =(
            const ArrayMultiDimensionEnum& x)
    {

                    m_var_array_enum = x.m_var_array_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionEnum& operator =(
            ArrayMultiDimensionEnum&& x) noexcept
    {

        m_var_array_enum = std::move(x.m_var_array_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionEnum& x) const
    {
        return (m_var_array_enum == x.m_var_array_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_enum
     * @param _var_array_enum New value to be copied in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            const std::array<std::array<std::array<InnerEnumHelper, 10>, 10>, 10>& _var_array_enum)
    {
        m_var_array_enum = _var_array_enum;
    }

    /*!
     * @brief This function moves the value in member var_array_enum
     * @param _var_array_enum New value to be moved in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            std::array<std::array<std::array<InnerEnumHelper, 10>, 10>, 10>&& _var_array_enum)
    {
        m_var_array_enum = std::move(_var_array_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_enum
     * @return Constant reference to member var_array_enum
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerEnumHelper, 10>, 10>, 10>& var_array_enum() const
    {
        return m_var_array_enum;
    }

    /*!
     * @brief This function returns a reference to member var_array_enum
     * @return Reference to member var_array_enum
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerEnumHelper, 10>, 10>, 10>& var_array_enum()
    {
        return m_var_array_enum;
    }



private:

    std::array<std::array<std::array<InnerEnumHelper, 10>, 10>, 10> m_var_array_enum{ {{ {{InnerEnumHelper::ENUM_VALUE_1}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionBitMask defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitMask(
            const ArrayMultiDimensionBitMask& x)
    {
                    m_var_array_bitmask = x.m_var_array_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitMask(
            ArrayMultiDimensionBitMask&& x) noexcept
    {
        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitMask& operator =(
            const ArrayMultiDimensionBitMask& x)
    {

                    m_var_array_bitmask = x.m_var_array_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitMask& operator =(
            ArrayMultiDimensionBitMask&& x) noexcept
    {

        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionBitMask& x) const
    {
        return (m_var_array_bitmask == x.m_var_array_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be copied in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            const std::array<std::array<std::array<InnerBitMaskHelper, 10>, 10>, 10>& _var_array_bitmask)
    {
        m_var_array_bitmask = _var_array_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be moved in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            std::array<std::array<std::array<InnerBitMaskHelper, 10>, 10>, 10>&& _var_array_bitmask)
    {
        m_var_array_bitmask = std::move(_var_array_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitmask
     * @return Constant reference to member var_array_bitmask
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerBitMaskHelper, 10>, 10>, 10>& var_array_bitmask() const
    {
        return m_var_array_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitmask
     * @return Reference to member var_array_bitmask
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerBitMaskHelper, 10>, 10>, 10>& var_array_bitmask()
    {
        return m_var_array_bitmask;
    }



private:

    std::array<std::array<std::array<InnerBitMaskHelper, 10>, 10>, 10> m_var_array_bitmask{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionAlias defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionAlias(
            const ArrayMultiDimensionAlias& x)
    {
                    m_var_array_alias = x.m_var_array_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionAlias(
            ArrayMultiDimensionAlias&& x) noexcept
    {
        m_var_array_alias = std::move(x.m_var_array_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionAlias& operator =(
            const ArrayMultiDimensionAlias& x)
    {

                    m_var_array_alias = x.m_var_array_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionAlias& operator =(
            ArrayMultiDimensionAlias&& x) noexcept
    {

        m_var_array_alias = std::move(x.m_var_array_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionAlias& x) const
    {
        return (m_var_array_alias == x.m_var_array_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_alias
     * @param _var_array_alias New value to be copied in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            const std::array<std::array<std::array<InnerAliasHelper, 10>, 10>, 10>& _var_array_alias)
    {
        m_var_array_alias = _var_array_alias;
    }

    /*!
     * @brief This function moves the value in member var_array_alias
     * @param _var_array_alias New value to be moved in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            std::array<std::array<std::array<InnerAliasHelper, 10>, 10>, 10>&& _var_array_alias)
    {
        m_var_array_alias = std::move(_var_array_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_alias
     * @return Constant reference to member var_array_alias
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerAliasHelper, 10>, 10>, 10>& var_array_alias() const
    {
        return m_var_array_alias;
    }

    /*!
     * @brief This function returns a reference to member var_array_alias
     * @return Reference to member var_array_alias
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerAliasHelper, 10>, 10>, 10>& var_array_alias()
    {
        return m_var_array_alias;
    }



private:

    std::array<std::array<std::array<InnerAliasHelper, 10>, 10>, 10> m_var_array_alias{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionSequence defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionSequence(
            const ArrayMultiDimensionSequence& x)
    {
                    m_var_array_sequence = x.m_var_array_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionSequence(
            ArrayMultiDimensionSequence&& x) noexcept
    {
        m_var_array_sequence = std::move(x.m_var_array_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionSequence& operator =(
            const ArrayMultiDimensionSequence& x)
    {

                    m_var_array_sequence = x.m_var_array_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionSequence& operator =(
            ArrayMultiDimensionSequence&& x) noexcept
    {

        m_var_array_sequence = std::move(x.m_var_array_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionSequence& x) const
    {
        return (m_var_array_sequence == x.m_var_array_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_sequence
     * @param _var_array_sequence New value to be copied in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            const std::array<std::array<std::array<std::vector<int32_t>, 10>, 10>, 10>& _var_array_sequence)
    {
        m_var_array_sequence = _var_array_sequence;
    }

    /*!
     * @brief This function moves the value in member var_array_sequence
     * @param _var_array_sequence New value to be moved in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            std::array<std::array<std::array<std::vector<int32_t>, 10>, 10>, 10>&& _var_array_sequence)
    {
        m_var_array_sequence = std::move(_var_array_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_sequence
     * @return Constant reference to member var_array_sequence
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::vector<int32_t>, 10>, 10>, 10>& var_array_sequence() const
    {
        return m_var_array_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_array_sequence
     * @return Reference to member var_array_sequence
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::vector<int32_t>, 10>, 10>, 10>& var_array_sequence()
    {
        return m_var_array_sequence;
    }



private:

    std::array<std::array<std::array<std::vector<int32_t>, 10>, 10>, 10> m_var_array_sequence;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionMap defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionMap(
            const ArrayMultiDimensionMap& x)
    {
                    m_var_array_map = x.m_var_array_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionMap(
            ArrayMultiDimensionMap&& x) noexcept
    {
        m_var_array_map = std::move(x.m_var_array_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionMap& operator =(
            const ArrayMultiDimensionMap& x)
    {

                    m_var_array_map = x.m_var_array_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionMap& operator =(
            ArrayMultiDimensionMap&& x) noexcept
    {

        m_var_array_map = std::move(x.m_var_array_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionMap& x) const
    {
        return (m_var_array_map == x.m_var_array_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_map
     * @param _var_array_map New value to be copied in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            const std::array<std::array<std::array<std::map<int32_t, int32_t>, 10>, 10>, 10>& _var_array_map)
    {
        m_var_array_map = _var_array_map;
    }

    /*!
     * @brief This function moves the value in member var_array_map
     * @param _var_array_map New value to be moved in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            std::array<std::array<std::array<std::map<int32_t, int32_t>, 10>, 10>, 10>&& _var_array_map)
    {
        m_var_array_map = std::move(_var_array_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_map
     * @return Constant reference to member var_array_map
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::map<int32_t, int32_t>, 10>, 10>, 10>& var_array_map() const
    {
        return m_var_array_map;
    }

    /*!
     * @brief This function returns a reference to member var_array_map
     * @return Reference to member var_array_map
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::map<int32_t, int32_t>, 10>, 10>, 10>& var_array_map()
    {
        return m_var_array_map;
    }



private:

    std::array<std::array<std::array<std::map<int32_t, int32_t>, 10>, 10>, 10> m_var_array_map;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionUnion defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUnion(
            const ArrayMultiDimensionUnion& x)
    {
                    m_var_array_union = x.m_var_array_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUnion(
            ArrayMultiDimensionUnion&& x) noexcept
    {
        m_var_array_union = std::move(x.m_var_array_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUnion& operator =(
            const ArrayMultiDimensionUnion& x)
    {

                    m_var_array_union = x.m_var_array_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionUnion& operator =(
            ArrayMultiDimensionUnion&& x) noexcept
    {

        m_var_array_union = std::move(x.m_var_array_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionUnion& x) const
    {
        return (m_var_array_union == x.m_var_array_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_union
     * @param _var_array_union New value to be copied in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            const std::array<std::array<std::array<InnerUnionHelper, 10>, 10>, 10>& _var_array_union)
    {
        m_var_array_union = _var_array_union;
    }

    /*!
     * @brief This function moves the value in member var_array_union
     * @param _var_array_union New value to be moved in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            std::array<std::array<std::array<InnerUnionHelper, 10>, 10>, 10>&& _var_array_union)
    {
        m_var_array_union = std::move(_var_array_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_union
     * @return Constant reference to member var_array_union
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerUnionHelper, 10>, 10>, 10>& var_array_union() const
    {
        return m_var_array_union;
    }

    /*!
     * @brief This function returns a reference to member var_array_union
     * @return Reference to member var_array_union
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerUnionHelper, 10>, 10>, 10>& var_array_union()
    {
        return m_var_array_union;
    }



private:

    std::array<std::array<std::array<InnerUnionHelper, 10>, 10>, 10> m_var_array_union;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionStructure defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionStructure(
            const ArrayMultiDimensionStructure& x)
    {
                    m_var_array_structure = x.m_var_array_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionStructure(
            ArrayMultiDimensionStructure&& x) noexcept
    {
        m_var_array_structure = std::move(x.m_var_array_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionStructure& operator =(
            const ArrayMultiDimensionStructure& x)
    {

                    m_var_array_structure = x.m_var_array_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionStructure& operator =(
            ArrayMultiDimensionStructure&& x) noexcept
    {

        m_var_array_structure = std::move(x.m_var_array_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionStructure& x) const
    {
        return (m_var_array_structure == x.m_var_array_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_structure
     * @param _var_array_structure New value to be copied in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            const std::array<std::array<std::array<InnerStructureHelper, 10>, 10>, 10>& _var_array_structure)
    {
        m_var_array_structure = _var_array_structure;
    }

    /*!
     * @brief This function moves the value in member var_array_structure
     * @param _var_array_structure New value to be moved in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            std::array<std::array<std::array<InnerStructureHelper, 10>, 10>, 10>&& _var_array_structure)
    {
        m_var_array_structure = std::move(_var_array_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_structure
     * @return Constant reference to member var_array_structure
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerStructureHelper, 10>, 10>, 10>& var_array_structure() const
    {
        return m_var_array_structure;
    }

    /*!
     * @brief This function returns a reference to member var_array_structure
     * @return Reference to member var_array_structure
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerStructureHelper, 10>, 10>, 10>& var_array_structure()
    {
        return m_var_array_structure;
    }



private:

    std::array<std::array<std::array<InnerStructureHelper, 10>, 10>, 10> m_var_array_structure;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionBitset defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionBitset that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitset(
            const ArrayMultiDimensionBitset& x)
    {
                    m_var_array_bitset = x.m_var_array_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionBitset that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitset(
            ArrayMultiDimensionBitset&& x) noexcept
    {
        m_var_array_bitset = std::move(x.m_var_array_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionBitset that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitset& operator =(
            const ArrayMultiDimensionBitset& x)
    {

                    m_var_array_bitset = x.m_var_array_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionBitset that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionBitset& operator =(
            ArrayMultiDimensionBitset&& x) noexcept
    {

        m_var_array_bitset = std::move(x.m_var_array_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionBitset& x) const
    {
        return (m_var_array_bitset == x.m_var_array_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitset
     * @param _var_array_bitset New value to be copied in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            const std::array<std::array<std::array<InnerBitsetHelper, 10>, 10>, 10>& _var_array_bitset)
    {
        m_var_array_bitset = _var_array_bitset;
    }

    /*!
     * @brief This function moves the value in member var_array_bitset
     * @param _var_array_bitset New value to be moved in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            std::array<std::array<std::array<InnerBitsetHelper, 10>, 10>, 10>&& _var_array_bitset)
    {
        m_var_array_bitset = std::move(_var_array_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitset
     * @return Constant reference to member var_array_bitset
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerBitsetHelper, 10>, 10>, 10>& var_array_bitset() const
    {
        return m_var_array_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitset
     * @return Reference to member var_array_bitset
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerBitsetHelper, 10>, 10>, 10>& var_array_bitset()
    {
        return m_var_array_bitset;
    }



private:

    std::array<std::array<std::array<InnerBitsetHelper, 10>, 10>, 10> m_var_array_bitset;

};
const int32_t size_1 = 5;
const int32_t size_2 = 2;
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShort(
            const ArraySingleDimensionLiteralsShort& x)
    {
                    m_var_array_short = x.m_var_array_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShort(
            ArraySingleDimensionLiteralsShort&& x) noexcept
    {
        m_var_array_short = std::move(x.m_var_array_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShort& operator =(
            const ArraySingleDimensionLiteralsShort& x)
    {

                    m_var_array_short = x.m_var_array_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShort& operator =(
            ArraySingleDimensionLiteralsShort&& x) noexcept
    {

        m_var_array_short = std::move(x.m_var_array_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsShort& x) const
    {
        return (m_var_array_short == x.m_var_array_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short
     * @param _var_array_short New value to be copied in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            const std::array<int16_t, size_1>& _var_array_short)
    {
        m_var_array_short = _var_array_short;
    }

    /*!
     * @brief This function moves the value in member var_array_short
     * @param _var_array_short New value to be moved in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            std::array<int16_t, size_1>&& _var_array_short)
    {
        m_var_array_short = std::move(_var_array_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short
     * @return Constant reference to member var_array_short
     */
    eProsima_user_DllExport const std::array<int16_t, size_1>& var_array_short() const
    {
        return m_var_array_short;
    }

    /*!
     * @brief This function returns a reference to member var_array_short
     * @return Reference to member var_array_short
     */
    eProsima_user_DllExport std::array<int16_t, size_1>& var_array_short()
    {
        return m_var_array_short;
    }



private:

    std::array<int16_t, size_1> m_var_array_short{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsUnsignedShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsUnsignedShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsUnsignedShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedShort(
            const ArraySingleDimensionLiteralsUnsignedShort& x)
    {
                    m_var_array_ushort = x.m_var_array_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedShort(
            ArraySingleDimensionLiteralsUnsignedShort&& x) noexcept
    {
        m_var_array_ushort = std::move(x.m_var_array_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedShort& operator =(
            const ArraySingleDimensionLiteralsUnsignedShort& x)
    {

                    m_var_array_ushort = x.m_var_array_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedShort that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedShort& operator =(
            ArraySingleDimensionLiteralsUnsignedShort&& x) noexcept
    {

        m_var_array_ushort = std::move(x.m_var_array_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsUnsignedShort& x) const
    {
        return (m_var_array_ushort == x.m_var_array_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsUnsignedShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ushort
     * @param _var_array_ushort New value to be copied in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            const std::array<uint16_t, 5*2>& _var_array_ushort)
    {
        m_var_array_ushort = _var_array_ushort;
    }

    /*!
     * @brief This function moves the value in member var_array_ushort
     * @param _var_array_ushort New value to be moved in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            std::array<uint16_t, 5*2>&& _var_array_ushort)
    {
        m_var_array_ushort = std::move(_var_array_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ushort
     * @return Constant reference to member var_array_ushort
     */
    eProsima_user_DllExport const std::array<uint16_t, 5*2>& var_array_ushort() const
    {
        return m_var_array_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_array_ushort
     * @return Reference to member var_array_ushort
     */
    eProsima_user_DllExport std::array<uint16_t, 5*2>& var_array_ushort()
    {
        return m_var_array_ushort;
    }



private:

    std::array<uint16_t, 5*2> m_var_array_ushort{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLong(
            const ArraySingleDimensionLiteralsLong& x)
    {
                    m_var_array_long = x.m_var_array_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLong(
            ArraySingleDimensionLiteralsLong&& x) noexcept
    {
        m_var_array_long = std::move(x.m_var_array_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLong& operator =(
            const ArraySingleDimensionLiteralsLong& x)
    {

                    m_var_array_long = x.m_var_array_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLong& operator =(
            ArraySingleDimensionLiteralsLong&& x) noexcept
    {

        m_var_array_long = std::move(x.m_var_array_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsLong& x) const
    {
        return (m_var_array_long == x.m_var_array_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_long
     * @param _var_array_long New value to be copied in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            const std::array<int32_t, 5+5>& _var_array_long)
    {
        m_var_array_long = _var_array_long;
    }

    /*!
     * @brief This function moves the value in member var_array_long
     * @param _var_array_long New value to be moved in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            std::array<int32_t, 5+5>&& _var_array_long)
    {
        m_var_array_long = std::move(_var_array_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_long
     * @return Constant reference to member var_array_long
     */
    eProsima_user_DllExport const std::array<int32_t, 5+5>& var_array_long() const
    {
        return m_var_array_long;
    }

    /*!
     * @brief This function returns a reference to member var_array_long
     * @return Reference to member var_array_long
     */
    eProsima_user_DllExport std::array<int32_t, 5+5>& var_array_long()
    {
        return m_var_array_long;
    }



private:

    std::array<int32_t, 5+5> m_var_array_long{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsUnsignedLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsUnsignedLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsUnsignedLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLong(
            const ArraySingleDimensionLiteralsUnsignedLong& x)
    {
                    m_var_array_ulong = x.m_var_array_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLong(
            ArraySingleDimensionLiteralsUnsignedLong&& x) noexcept
    {
        m_var_array_ulong = std::move(x.m_var_array_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLong& operator =(
            const ArraySingleDimensionLiteralsUnsignedLong& x)
    {

                    m_var_array_ulong = x.m_var_array_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLong& operator =(
            ArraySingleDimensionLiteralsUnsignedLong&& x) noexcept
    {

        m_var_array_ulong = std::move(x.m_var_array_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsUnsignedLong& x) const
    {
        return (m_var_array_ulong == x.m_var_array_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsUnsignedLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulong
     * @param _var_array_ulong New value to be copied in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            const std::array<uint32_t, size_1*2>& _var_array_ulong)
    {
        m_var_array_ulong = _var_array_ulong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulong
     * @param _var_array_ulong New value to be moved in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            std::array<uint32_t, size_1*2>&& _var_array_ulong)
    {
        m_var_array_ulong = std::move(_var_array_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulong
     * @return Constant reference to member var_array_ulong
     */
    eProsima_user_DllExport const std::array<uint32_t, size_1*2>& var_array_ulong() const
    {
        return m_var_array_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulong
     * @return Reference to member var_array_ulong
     */
    eProsima_user_DllExport std::array<uint32_t, size_1*2>& var_array_ulong()
    {
        return m_var_array_ulong;
    }



private:

    std::array<uint32_t, size_1*2> m_var_array_ulong{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsLongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongLong(
            const ArraySingleDimensionLiteralsLongLong& x)
    {
                    m_var_array_longlong = x.m_var_array_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongLong(
            ArraySingleDimensionLiteralsLongLong&& x) noexcept
    {
        m_var_array_longlong = std::move(x.m_var_array_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongLong& operator =(
            const ArraySingleDimensionLiteralsLongLong& x)
    {

                    m_var_array_longlong = x.m_var_array_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongLong& operator =(
            ArraySingleDimensionLiteralsLongLong&& x) noexcept
    {

        m_var_array_longlong = std::move(x.m_var_array_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsLongLong& x) const
    {
        return (m_var_array_longlong == x.m_var_array_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longlong
     * @param _var_array_longlong New value to be copied in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            const std::array<int64_t, size_1+5>& _var_array_longlong)
    {
        m_var_array_longlong = _var_array_longlong;
    }

    /*!
     * @brief This function moves the value in member var_array_longlong
     * @param _var_array_longlong New value to be moved in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            std::array<int64_t, size_1+5>&& _var_array_longlong)
    {
        m_var_array_longlong = std::move(_var_array_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longlong
     * @return Constant reference to member var_array_longlong
     */
    eProsima_user_DllExport const std::array<int64_t, size_1+5>& var_array_longlong() const
    {
        return m_var_array_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_array_longlong
     * @return Reference to member var_array_longlong
     */
    eProsima_user_DllExport std::array<int64_t, size_1+5>& var_array_longlong()
    {
        return m_var_array_longlong;
    }



private:

    std::array<int64_t, size_1+5> m_var_array_longlong{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsUnsignedLongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsUnsignedLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsUnsignedLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLongLong(
            const ArraySingleDimensionLiteralsUnsignedLongLong& x)
    {
                    m_var_array_ulonglong = x.m_var_array_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLongLong(
            ArraySingleDimensionLiteralsUnsignedLongLong&& x) noexcept
    {
        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLongLong& operator =(
            const ArraySingleDimensionLiteralsUnsignedLongLong& x)
    {

                    m_var_array_ulonglong = x.m_var_array_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnsignedLongLong& operator =(
            ArraySingleDimensionLiteralsUnsignedLongLong&& x) noexcept
    {

        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsUnsignedLongLong& x) const
    {
        return (m_var_array_ulonglong == x.m_var_array_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnsignedLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsUnsignedLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be copied in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            const std::array<uint64_t, size_1*size_2>& _var_array_ulonglong)
    {
        m_var_array_ulonglong = _var_array_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be moved in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            std::array<uint64_t, size_1*size_2>&& _var_array_ulonglong)
    {
        m_var_array_ulonglong = std::move(_var_array_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulonglong
     * @return Constant reference to member var_array_ulonglong
     */
    eProsima_user_DllExport const std::array<uint64_t, size_1*size_2>& var_array_ulonglong() const
    {
        return m_var_array_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulonglong
     * @return Reference to member var_array_ulonglong
     */
    eProsima_user_DllExport std::array<uint64_t, size_1*size_2>& var_array_ulonglong()
    {
        return m_var_array_ulonglong;
    }



private:

    std::array<uint64_t, size_1*size_2> m_var_array_ulonglong{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsFloat defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsFloat(
            const ArraySingleDimensionLiteralsFloat& x)
    {
                    m_var_array_float = x.m_var_array_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsFloat(
            ArraySingleDimensionLiteralsFloat&& x) noexcept
    {
        m_var_array_float = std::move(x.m_var_array_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsFloat& operator =(
            const ArraySingleDimensionLiteralsFloat& x)
    {

                    m_var_array_float = x.m_var_array_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsFloat& operator =(
            ArraySingleDimensionLiteralsFloat&& x) noexcept
    {

        m_var_array_float = std::move(x.m_var_array_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsFloat& x) const
    {
        return (m_var_array_float == x.m_var_array_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_float
     * @param _var_array_float New value to be copied in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            const std::array<float, size_1>& _var_array_float)
    {
        m_var_array_float = _var_array_float;
    }

    /*!
     * @brief This function moves the value in member var_array_float
     * @param _var_array_float New value to be moved in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            std::array<float, size_1>&& _var_array_float)
    {
        m_var_array_float = std::move(_var_array_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_float
     * @return Constant reference to member var_array_float
     */
    eProsima_user_DllExport const std::array<float, size_1>& var_array_float() const
    {
        return m_var_array_float;
    }

    /*!
     * @brief This function returns a reference to member var_array_float
     * @return Reference to member var_array_float
     */
    eProsima_user_DllExport std::array<float, size_1>& var_array_float()
    {
        return m_var_array_float;
    }



private:

    std::array<float, size_1> m_var_array_float{0.0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsDouble(
            const ArraySingleDimensionLiteralsDouble& x)
    {
                    m_var_array_double = x.m_var_array_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsDouble(
            ArraySingleDimensionLiteralsDouble&& x) noexcept
    {
        m_var_array_double = std::move(x.m_var_array_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsDouble& operator =(
            const ArraySingleDimensionLiteralsDouble& x)
    {

                    m_var_array_double = x.m_var_array_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsDouble& operator =(
            ArraySingleDimensionLiteralsDouble&& x) noexcept
    {

        m_var_array_double = std::move(x.m_var_array_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsDouble& x) const
    {
        return (m_var_array_double == x.m_var_array_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_double
     * @param _var_array_double New value to be copied in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            const std::array<double, 5*2>& _var_array_double)
    {
        m_var_array_double = _var_array_double;
    }

    /*!
     * @brief This function moves the value in member var_array_double
     * @param _var_array_double New value to be moved in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            std::array<double, 5*2>&& _var_array_double)
    {
        m_var_array_double = std::move(_var_array_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_double
     * @return Constant reference to member var_array_double
     */
    eProsima_user_DllExport const std::array<double, 5*2>& var_array_double() const
    {
        return m_var_array_double;
    }

    /*!
     * @brief This function returns a reference to member var_array_double
     * @return Reference to member var_array_double
     */
    eProsima_user_DllExport std::array<double, 5*2>& var_array_double()
    {
        return m_var_array_double;
    }



private:

    std::array<double, 5*2> m_var_array_double{0.0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsLongDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongDouble(
            const ArraySingleDimensionLiteralsLongDouble& x)
    {
                    m_var_array_longdouble = x.m_var_array_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongDouble(
            ArraySingleDimensionLiteralsLongDouble&& x) noexcept
    {
        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongDouble& operator =(
            const ArraySingleDimensionLiteralsLongDouble& x)
    {

                    m_var_array_longdouble = x.m_var_array_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsLongDouble& operator =(
            ArraySingleDimensionLiteralsLongDouble&& x) noexcept
    {

        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsLongDouble& x) const
    {
        return (m_var_array_longdouble == x.m_var_array_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be copied in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            const std::array<long double, 5+5>& _var_array_longdouble)
    {
        m_var_array_longdouble = _var_array_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be moved in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            std::array<long double, 5+5>&& _var_array_longdouble)
    {
        m_var_array_longdouble = std::move(_var_array_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longdouble
     * @return Constant reference to member var_array_longdouble
     */
    eProsima_user_DllExport const std::array<long double, 5+5>& var_array_longdouble() const
    {
        return m_var_array_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_array_longdouble
     * @return Reference to member var_array_longdouble
     */
    eProsima_user_DllExport std::array<long double, 5+5>& var_array_longdouble()
    {
        return m_var_array_longdouble;
    }



private:

    std::array<long double, 5+5> m_var_array_longdouble{0.0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsBoolean defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoolean(
            const ArraySingleDimensionLiteralsBoolean& x)
    {
                    m_var_array_boolean = x.m_var_array_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoolean(
            ArraySingleDimensionLiteralsBoolean&& x) noexcept
    {
        m_var_array_boolean = std::move(x.m_var_array_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoolean& operator =(
            const ArraySingleDimensionLiteralsBoolean& x)
    {

                    m_var_array_boolean = x.m_var_array_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoolean& operator =(
            ArraySingleDimensionLiteralsBoolean&& x) noexcept
    {

        m_var_array_boolean = std::move(x.m_var_array_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsBoolean& x) const
    {
        return (m_var_array_boolean == x.m_var_array_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_boolean
     * @param _var_array_boolean New value to be copied in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            const std::array<bool, size_1>& _var_array_boolean)
    {
        m_var_array_boolean = _var_array_boolean;
    }

    /*!
     * @brief This function moves the value in member var_array_boolean
     * @param _var_array_boolean New value to be moved in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            std::array<bool, size_1>&& _var_array_boolean)
    {
        m_var_array_boolean = std::move(_var_array_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_boolean
     * @return Constant reference to member var_array_boolean
     */
    eProsima_user_DllExport const std::array<bool, size_1>& var_array_boolean() const
    {
        return m_var_array_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_array_boolean
     * @return Reference to member var_array_boolean
     */
    eProsima_user_DllExport std::array<bool, size_1>& var_array_boolean()
    {
        return m_var_array_boolean;
    }



private:

    std::array<bool, size_1> m_var_array_boolean{false};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsOctet defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsOctet(
            const ArraySingleDimensionLiteralsOctet& x)
    {
                    m_var_array_octet = x.m_var_array_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsOctet(
            ArraySingleDimensionLiteralsOctet&& x) noexcept
    {
        m_var_array_octet = std::move(x.m_var_array_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsOctet& operator =(
            const ArraySingleDimensionLiteralsOctet& x)
    {

                    m_var_array_octet = x.m_var_array_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsOctet& operator =(
            ArraySingleDimensionLiteralsOctet&& x) noexcept
    {

        m_var_array_octet = std::move(x.m_var_array_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsOctet& x) const
    {
        return (m_var_array_octet == x.m_var_array_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_octet
     * @param _var_array_octet New value to be copied in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            const std::array<uint8_t, size_1*2>& _var_array_octet)
    {
        m_var_array_octet = _var_array_octet;
    }

    /*!
     * @brief This function moves the value in member var_array_octet
     * @param _var_array_octet New value to be moved in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            std::array<uint8_t, size_1*2>&& _var_array_octet)
    {
        m_var_array_octet = std::move(_var_array_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_octet
     * @return Constant reference to member var_array_octet
     */
    eProsima_user_DllExport const std::array<uint8_t, size_1*2>& var_array_octet() const
    {
        return m_var_array_octet;
    }

    /*!
     * @brief This function returns a reference to member var_array_octet
     * @return Reference to member var_array_octet
     */
    eProsima_user_DllExport std::array<uint8_t, size_1*2>& var_array_octet()
    {
        return m_var_array_octet;
    }



private:

    std::array<uint8_t, size_1*2> m_var_array_octet{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsChar(
            const ArraySingleDimensionLiteralsChar& x)
    {
                    m_var_array_char = x.m_var_array_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsChar(
            ArraySingleDimensionLiteralsChar&& x) noexcept
    {
        m_var_array_char = std::move(x.m_var_array_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsChar& operator =(
            const ArraySingleDimensionLiteralsChar& x)
    {

                    m_var_array_char = x.m_var_array_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsChar& operator =(
            ArraySingleDimensionLiteralsChar&& x) noexcept
    {

        m_var_array_char = std::move(x.m_var_array_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsChar& x) const
    {
        return (m_var_array_char == x.m_var_array_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_char
     * @param _var_array_char New value to be copied in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            const std::array<char, size_1>& _var_array_char)
    {
        m_var_array_char = _var_array_char;
    }

    /*!
     * @brief This function moves the value in member var_array_char
     * @param _var_array_char New value to be moved in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            std::array<char, size_1>&& _var_array_char)
    {
        m_var_array_char = std::move(_var_array_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_char
     * @return Constant reference to member var_array_char
     */
    eProsima_user_DllExport const std::array<char, size_1>& var_array_char() const
    {
        return m_var_array_char;
    }

    /*!
     * @brief This function returns a reference to member var_array_char
     * @return Reference to member var_array_char
     */
    eProsima_user_DllExport std::array<char, size_1>& var_array_char()
    {
        return m_var_array_char;
    }



private:

    std::array<char, size_1> m_var_array_char{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsWChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWChar(
            const ArraySingleDimensionLiteralsWChar& x)
    {
                    m_var_array_wchar = x.m_var_array_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWChar(
            ArraySingleDimensionLiteralsWChar&& x) noexcept
    {
        m_var_array_wchar = std::move(x.m_var_array_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWChar& operator =(
            const ArraySingleDimensionLiteralsWChar& x)
    {

                    m_var_array_wchar = x.m_var_array_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWChar& operator =(
            ArraySingleDimensionLiteralsWChar&& x) noexcept
    {

        m_var_array_wchar = std::move(x.m_var_array_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsWChar& x) const
    {
        return (m_var_array_wchar == x.m_var_array_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wchar
     * @param _var_array_wchar New value to be copied in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            const std::array<wchar_t, size_1+5>& _var_array_wchar)
    {
        m_var_array_wchar = _var_array_wchar;
    }

    /*!
     * @brief This function moves the value in member var_array_wchar
     * @param _var_array_wchar New value to be moved in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            std::array<wchar_t, size_1+5>&& _var_array_wchar)
    {
        m_var_array_wchar = std::move(_var_array_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wchar
     * @return Constant reference to member var_array_wchar
     */
    eProsima_user_DllExport const std::array<wchar_t, size_1+5>& var_array_wchar() const
    {
        return m_var_array_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_array_wchar
     * @return Reference to member var_array_wchar
     */
    eProsima_user_DllExport std::array<wchar_t, size_1+5>& var_array_wchar()
    {
        return m_var_array_wchar;
    }



private:

    std::array<wchar_t, size_1+5> m_var_array_wchar{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsString(
            const ArraySingleDimensionLiteralsString& x)
    {
                    m_var_array_string = x.m_var_array_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsString(
            ArraySingleDimensionLiteralsString&& x) noexcept
    {
        m_var_array_string = std::move(x.m_var_array_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsString& operator =(
            const ArraySingleDimensionLiteralsString& x)
    {

                    m_var_array_string = x.m_var_array_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsString& operator =(
            ArraySingleDimensionLiteralsString&& x) noexcept
    {

        m_var_array_string = std::move(x.m_var_array_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsString& x) const
    {
        return (m_var_array_string == x.m_var_array_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_string
     * @param _var_array_string New value to be copied in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            const std::array<std::string, size_1>& _var_array_string)
    {
        m_var_array_string = _var_array_string;
    }

    /*!
     * @brief This function moves the value in member var_array_string
     * @param _var_array_string New value to be moved in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            std::array<std::string, size_1>&& _var_array_string)
    {
        m_var_array_string = std::move(_var_array_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_string
     * @return Constant reference to member var_array_string
     */
    eProsima_user_DllExport const std::array<std::string, size_1>& var_array_string() const
    {
        return m_var_array_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_string
     * @return Reference to member var_array_string
     */
    eProsima_user_DllExport std::array<std::string, size_1>& var_array_string()
    {
        return m_var_array_string;
    }



private:

    std::array<std::string, size_1> m_var_array_string;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWString(
            const ArraySingleDimensionLiteralsWString& x)
    {
                    m_var_array_wstring = x.m_var_array_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWString(
            ArraySingleDimensionLiteralsWString&& x) noexcept
    {
        m_var_array_wstring = std::move(x.m_var_array_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWString& operator =(
            const ArraySingleDimensionLiteralsWString& x)
    {

                    m_var_array_wstring = x.m_var_array_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsWString& operator =(
            ArraySingleDimensionLiteralsWString&& x) noexcept
    {

        m_var_array_wstring = std::move(x.m_var_array_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsWString& x) const
    {
        return (m_var_array_wstring == x.m_var_array_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wstring
     * @param _var_array_wstring New value to be copied in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            const std::array<std::wstring, size_1*size_2>& _var_array_wstring)
    {
        m_var_array_wstring = _var_array_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_wstring
     * @param _var_array_wstring New value to be moved in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            std::array<std::wstring, size_1*size_2>&& _var_array_wstring)
    {
        m_var_array_wstring = std::move(_var_array_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wstring
     * @return Constant reference to member var_array_wstring
     */
    eProsima_user_DllExport const std::array<std::wstring, size_1*size_2>& var_array_wstring() const
    {
        return m_var_array_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_wstring
     * @return Reference to member var_array_wstring
     */
    eProsima_user_DllExport std::array<std::wstring, size_1*size_2>& var_array_wstring()
    {
        return m_var_array_wstring;
    }



private:

    std::array<std::wstring, size_1*size_2> m_var_array_wstring;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsBoundedString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedString(
            const ArraySingleDimensionLiteralsBoundedString& x)
    {
                    m_var_array_bounded_string = x.m_var_array_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedString(
            ArraySingleDimensionLiteralsBoundedString&& x) noexcept
    {
        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedString& operator =(
            const ArraySingleDimensionLiteralsBoundedString& x)
    {

                    m_var_array_bounded_string = x.m_var_array_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedString& operator =(
            ArraySingleDimensionLiteralsBoundedString&& x) noexcept
    {

        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsBoundedString& x) const
    {
        return (m_var_array_bounded_string == x.m_var_array_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be copied in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            const std::array<Inner_alias_bounded_string_helper, size_1>& _var_array_bounded_string)
    {
        m_var_array_bounded_string = _var_array_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be moved in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            std::array<Inner_alias_bounded_string_helper, size_1>&& _var_array_bounded_string)
    {
        m_var_array_bounded_string = std::move(_var_array_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_string
     * @return Constant reference to member var_array_bounded_string
     */
    eProsima_user_DllExport const std::array<Inner_alias_bounded_string_helper, size_1>& var_array_bounded_string() const
    {
        return m_var_array_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_string
     * @return Reference to member var_array_bounded_string
     */
    eProsima_user_DllExport std::array<Inner_alias_bounded_string_helper, size_1>& var_array_bounded_string()
    {
        return m_var_array_bounded_string;
    }



private:

    std::array<Inner_alias_bounded_string_helper, size_1> m_var_array_bounded_string;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsBoundedWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedWString(
            const ArraySingleDimensionLiteralsBoundedWString& x)
    {
                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedWString(
            ArraySingleDimensionLiteralsBoundedWString&& x) noexcept
    {
        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedWString& operator =(
            const ArraySingleDimensionLiteralsBoundedWString& x)
    {

                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBoundedWString& operator =(
            ArraySingleDimensionLiteralsBoundedWString&& x) noexcept
    {

        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsBoundedWString& x) const
    {
        return (m_var_array_bounded_wstring == x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be copied in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            const std::array<Inner_alias_bounded_wstring_helper, size_1*size_2>& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = _var_array_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be moved in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            std::array<Inner_alias_bounded_wstring_helper, size_1*size_2>&& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = std::move(_var_array_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_wstring
     * @return Constant reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport const std::array<Inner_alias_bounded_wstring_helper, size_1*size_2>& var_array_bounded_wstring() const
    {
        return m_var_array_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_wstring
     * @return Reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport std::array<Inner_alias_bounded_wstring_helper, size_1*size_2>& var_array_bounded_wstring()
    {
        return m_var_array_bounded_wstring;
    }



private:

    std::array<Inner_alias_bounded_wstring_helper, size_1*size_2> m_var_array_bounded_wstring;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsEnum defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsEnum(
            const ArraySingleDimensionLiteralsEnum& x)
    {
                    m_var_array_enum = x.m_var_array_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsEnum(
            ArraySingleDimensionLiteralsEnum&& x) noexcept
    {
        m_var_array_enum = std::move(x.m_var_array_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsEnum& operator =(
            const ArraySingleDimensionLiteralsEnum& x)
    {

                    m_var_array_enum = x.m_var_array_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsEnum& operator =(
            ArraySingleDimensionLiteralsEnum&& x) noexcept
    {

        m_var_array_enum = std::move(x.m_var_array_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsEnum& x) const
    {
        return (m_var_array_enum == x.m_var_array_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_enum
     * @param _var_array_enum New value to be copied in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            const std::array<InnerEnumHelper, size_1>& _var_array_enum)
    {
        m_var_array_enum = _var_array_enum;
    }

    /*!
     * @brief This function moves the value in member var_array_enum
     * @param _var_array_enum New value to be moved in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            std::array<InnerEnumHelper, size_1>&& _var_array_enum)
    {
        m_var_array_enum = std::move(_var_array_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_enum
     * @return Constant reference to member var_array_enum
     */
    eProsima_user_DllExport const std::array<InnerEnumHelper, size_1>& var_array_enum() const
    {
        return m_var_array_enum;
    }

    /*!
     * @brief This function returns a reference to member var_array_enum
     * @return Reference to member var_array_enum
     */
    eProsima_user_DllExport std::array<InnerEnumHelper, size_1>& var_array_enum()
    {
        return m_var_array_enum;
    }



private:

    std::array<InnerEnumHelper, size_1> m_var_array_enum{InnerEnumHelper::ENUM_VALUE_1};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsBitMask defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitMask(
            const ArraySingleDimensionLiteralsBitMask& x)
    {
                    m_var_array_bitmask = x.m_var_array_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitMask(
            ArraySingleDimensionLiteralsBitMask&& x) noexcept
    {
        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitMask& operator =(
            const ArraySingleDimensionLiteralsBitMask& x)
    {

                    m_var_array_bitmask = x.m_var_array_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitMask& operator =(
            ArraySingleDimensionLiteralsBitMask&& x) noexcept
    {

        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsBitMask& x) const
    {
        return (m_var_array_bitmask == x.m_var_array_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be copied in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            const std::array<InnerBitMaskHelper, size_1+5>& _var_array_bitmask)
    {
        m_var_array_bitmask = _var_array_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be moved in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            std::array<InnerBitMaskHelper, size_1+5>&& _var_array_bitmask)
    {
        m_var_array_bitmask = std::move(_var_array_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitmask
     * @return Constant reference to member var_array_bitmask
     */
    eProsima_user_DllExport const std::array<InnerBitMaskHelper, size_1+5>& var_array_bitmask() const
    {
        return m_var_array_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitmask
     * @return Reference to member var_array_bitmask
     */
    eProsima_user_DllExport std::array<InnerBitMaskHelper, size_1+5>& var_array_bitmask()
    {
        return m_var_array_bitmask;
    }



private:

    std::array<InnerBitMaskHelper, size_1+5> m_var_array_bitmask{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsAlias defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsAlias(
            const ArraySingleDimensionLiteralsAlias& x)
    {
                    m_var_array_alias = x.m_var_array_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsAlias(
            ArraySingleDimensionLiteralsAlias&& x) noexcept
    {
        m_var_array_alias = std::move(x.m_var_array_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsAlias& operator =(
            const ArraySingleDimensionLiteralsAlias& x)
    {

                    m_var_array_alias = x.m_var_array_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsAlias& operator =(
            ArraySingleDimensionLiteralsAlias&& x) noexcept
    {

        m_var_array_alias = std::move(x.m_var_array_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsAlias& x) const
    {
        return (m_var_array_alias == x.m_var_array_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_alias
     * @param _var_array_alias New value to be copied in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            const std::array<InnerAliasHelper, size_1*2>& _var_array_alias)
    {
        m_var_array_alias = _var_array_alias;
    }

    /*!
     * @brief This function moves the value in member var_array_alias
     * @param _var_array_alias New value to be moved in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            std::array<InnerAliasHelper, size_1*2>&& _var_array_alias)
    {
        m_var_array_alias = std::move(_var_array_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_alias
     * @return Constant reference to member var_array_alias
     */
    eProsima_user_DllExport const std::array<InnerAliasHelper, size_1*2>& var_array_alias() const
    {
        return m_var_array_alias;
    }

    /*!
     * @brief This function returns a reference to member var_array_alias
     * @return Reference to member var_array_alias
     */
    eProsima_user_DllExport std::array<InnerAliasHelper, size_1*2>& var_array_alias()
    {
        return m_var_array_alias;
    }



private:

    std::array<InnerAliasHelper, size_1*2> m_var_array_alias{0};

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsShortArray defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsShortArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShortArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsShortArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsShortArray that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShortArray(
            const ArraySingleDimensionLiteralsShortArray& x)
    {
                    m_var_array_short_array = x.m_var_array_short_array;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsShortArray that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShortArray(
            ArraySingleDimensionLiteralsShortArray&& x) noexcept
    {
        m_var_array_short_array = std::move(x.m_var_array_short_array);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsShortArray that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShortArray& operator =(
            const ArraySingleDimensionLiteralsShortArray& x)
    {

                    m_var_array_short_array = x.m_var_array_short_array;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsShortArray that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsShortArray& operator =(
            ArraySingleDimensionLiteralsShortArray&& x) noexcept
    {

        m_var_array_short_array = std::move(x.m_var_array_short_array);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsShortArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsShortArray& x) const
    {
        return (m_var_array_short_array == x.m_var_array_short_array);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsShortArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsShortArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short_array
     * @param _var_array_short_array New value to be copied in member var_array_short_array
     */
    eProsima_user_DllExport void var_array_short_array(
            const std::array<std::array<int16_t, size_1+5>, size_1*size_2>& _var_array_short_array)
    {
        m_var_array_short_array = _var_array_short_array;
    }

    /*!
     * @brief This function moves the value in member var_array_short_array
     * @param _var_array_short_array New value to be moved in member var_array_short_array
     */
    eProsima_user_DllExport void var_array_short_array(
            std::array<std::array<int16_t, size_1+5>, size_1*size_2>&& _var_array_short_array)
    {
        m_var_array_short_array = std::move(_var_array_short_array);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short_array
     * @return Constant reference to member var_array_short_array
     */
    eProsima_user_DllExport const std::array<std::array<int16_t, size_1+5>, size_1*size_2>& var_array_short_array() const
    {
        return m_var_array_short_array;
    }

    /*!
     * @brief This function returns a reference to member var_array_short_array
     * @return Reference to member var_array_short_array
     */
    eProsima_user_DllExport std::array<std::array<int16_t, size_1+5>, size_1*size_2>& var_array_short_array()
    {
        return m_var_array_short_array;
    }



private:

    std::array<std::array<int16_t, size_1+5>, size_1*size_2> m_var_array_short_array{ {{0}} };

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsSequence defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsSequence(
            const ArraySingleDimensionLiteralsSequence& x)
    {
                    m_var_array_sequence = x.m_var_array_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsSequence(
            ArraySingleDimensionLiteralsSequence&& x) noexcept
    {
        m_var_array_sequence = std::move(x.m_var_array_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsSequence& operator =(
            const ArraySingleDimensionLiteralsSequence& x)
    {

                    m_var_array_sequence = x.m_var_array_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsSequence& operator =(
            ArraySingleDimensionLiteralsSequence&& x) noexcept
    {

        m_var_array_sequence = std::move(x.m_var_array_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsSequence& x) const
    {
        return (m_var_array_sequence == x.m_var_array_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_sequence
     * @param _var_array_sequence New value to be copied in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            const std::array<std::vector<int32_t>, size_1>& _var_array_sequence)
    {
        m_var_array_sequence = _var_array_sequence;
    }

    /*!
     * @brief This function moves the value in member var_array_sequence
     * @param _var_array_sequence New value to be moved in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            std::array<std::vector<int32_t>, size_1>&& _var_array_sequence)
    {
        m_var_array_sequence = std::move(_var_array_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_sequence
     * @return Constant reference to member var_array_sequence
     */
    eProsima_user_DllExport const std::array<std::vector<int32_t>, size_1>& var_array_sequence() const
    {
        return m_var_array_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_array_sequence
     * @return Reference to member var_array_sequence
     */
    eProsima_user_DllExport std::array<std::vector<int32_t>, size_1>& var_array_sequence()
    {
        return m_var_array_sequence;
    }



private:

    std::array<std::vector<int32_t>, size_1> m_var_array_sequence;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsMap defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsMap(
            const ArraySingleDimensionLiteralsMap& x)
    {
                    m_var_array_map = x.m_var_array_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsMap(
            ArraySingleDimensionLiteralsMap&& x) noexcept
    {
        m_var_array_map = std::move(x.m_var_array_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsMap& operator =(
            const ArraySingleDimensionLiteralsMap& x)
    {

                    m_var_array_map = x.m_var_array_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsMap& operator =(
            ArraySingleDimensionLiteralsMap&& x) noexcept
    {

        m_var_array_map = std::move(x.m_var_array_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsMap& x) const
    {
        return (m_var_array_map == x.m_var_array_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_map
     * @param _var_array_map New value to be copied in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            const std::array<std::map<int32_t, int32_t>, size_2>& _var_array_map)
    {
        m_var_array_map = _var_array_map;
    }

    /*!
     * @brief This function moves the value in member var_array_map
     * @param _var_array_map New value to be moved in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            std::array<std::map<int32_t, int32_t>, size_2>&& _var_array_map)
    {
        m_var_array_map = std::move(_var_array_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_map
     * @return Constant reference to member var_array_map
     */
    eProsima_user_DllExport const std::array<std::map<int32_t, int32_t>, size_2>& var_array_map() const
    {
        return m_var_array_map;
    }

    /*!
     * @brief This function returns a reference to member var_array_map
     * @return Reference to member var_array_map
     */
    eProsima_user_DllExport std::array<std::map<int32_t, int32_t>, size_2>& var_array_map()
    {
        return m_var_array_map;
    }



private:

    std::array<std::map<int32_t, int32_t>, size_2> m_var_array_map;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsUnion defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnion(
            const ArraySingleDimensionLiteralsUnion& x)
    {
                    m_var_array_union = x.m_var_array_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnion(
            ArraySingleDimensionLiteralsUnion&& x) noexcept
    {
        m_var_array_union = std::move(x.m_var_array_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnion& operator =(
            const ArraySingleDimensionLiteralsUnion& x)
    {

                    m_var_array_union = x.m_var_array_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsUnion& operator =(
            ArraySingleDimensionLiteralsUnion&& x) noexcept
    {

        m_var_array_union = std::move(x.m_var_array_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsUnion& x) const
    {
        return (m_var_array_union == x.m_var_array_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_union
     * @param _var_array_union New value to be copied in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            const std::array<InnerUnionHelper, 5*2>& _var_array_union)
    {
        m_var_array_union = _var_array_union;
    }

    /*!
     * @brief This function moves the value in member var_array_union
     * @param _var_array_union New value to be moved in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            std::array<InnerUnionHelper, 5*2>&& _var_array_union)
    {
        m_var_array_union = std::move(_var_array_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_union
     * @return Constant reference to member var_array_union
     */
    eProsima_user_DllExport const std::array<InnerUnionHelper, 5*2>& var_array_union() const
    {
        return m_var_array_union;
    }

    /*!
     * @brief This function returns a reference to member var_array_union
     * @return Reference to member var_array_union
     */
    eProsima_user_DllExport std::array<InnerUnionHelper, 5*2>& var_array_union()
    {
        return m_var_array_union;
    }



private:

    std::array<InnerUnionHelper, 5*2> m_var_array_union;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsStructure defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsStructure(
            const ArraySingleDimensionLiteralsStructure& x)
    {
                    m_var_array_structure = x.m_var_array_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsStructure(
            ArraySingleDimensionLiteralsStructure&& x) noexcept
    {
        m_var_array_structure = std::move(x.m_var_array_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsStructure& operator =(
            const ArraySingleDimensionLiteralsStructure& x)
    {

                    m_var_array_structure = x.m_var_array_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsStructure& operator =(
            ArraySingleDimensionLiteralsStructure&& x) noexcept
    {

        m_var_array_structure = std::move(x.m_var_array_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsStructure& x) const
    {
        return (m_var_array_structure == x.m_var_array_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_structure
     * @param _var_array_structure New value to be copied in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            const std::array<InnerStructureHelper, size_1>& _var_array_structure)
    {
        m_var_array_structure = _var_array_structure;
    }

    /*!
     * @brief This function moves the value in member var_array_structure
     * @param _var_array_structure New value to be moved in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            std::array<InnerStructureHelper, size_1>&& _var_array_structure)
    {
        m_var_array_structure = std::move(_var_array_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_structure
     * @return Constant reference to member var_array_structure
     */
    eProsima_user_DllExport const std::array<InnerStructureHelper, size_1>& var_array_structure() const
    {
        return m_var_array_structure;
    }

    /*!
     * @brief This function returns a reference to member var_array_structure
     * @return Reference to member var_array_structure
     */
    eProsima_user_DllExport std::array<InnerStructureHelper, size_1>& var_array_structure()
    {
        return m_var_array_structure;
    }



private:

    std::array<InnerStructureHelper, size_1> m_var_array_structure;

};
/*!
 * @brief This class represents the structure ArraySingleDimensionLiteralsBitset defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArraySingleDimensionLiteralsBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArraySingleDimensionLiteralsBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitset that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitset(
            const ArraySingleDimensionLiteralsBitset& x)
    {
                    m_var_array_bitset = x.m_var_array_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitset that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitset(
            ArraySingleDimensionLiteralsBitset&& x) noexcept
    {
        m_var_array_bitset = std::move(x.m_var_array_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitset that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitset& operator =(
            const ArraySingleDimensionLiteralsBitset& x)
    {

                    m_var_array_bitset = x.m_var_array_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArraySingleDimensionLiteralsBitset that will be copied.
     */
    eProsima_user_DllExport ArraySingleDimensionLiteralsBitset& operator =(
            ArraySingleDimensionLiteralsBitset&& x) noexcept
    {

        m_var_array_bitset = std::move(x.m_var_array_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArraySingleDimensionLiteralsBitset& x) const
    {
        return (m_var_array_bitset == x.m_var_array_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArraySingleDimensionLiteralsBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArraySingleDimensionLiteralsBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitset
     * @param _var_array_bitset New value to be copied in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            const std::array<InnerBitsetHelper, size_1+5>& _var_array_bitset)
    {
        m_var_array_bitset = _var_array_bitset;
    }

    /*!
     * @brief This function moves the value in member var_array_bitset
     * @param _var_array_bitset New value to be moved in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            std::array<InnerBitsetHelper, size_1+5>&& _var_array_bitset)
    {
        m_var_array_bitset = std::move(_var_array_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitset
     * @return Constant reference to member var_array_bitset
     */
    eProsima_user_DllExport const std::array<InnerBitsetHelper, size_1+5>& var_array_bitset() const
    {
        return m_var_array_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitset
     * @return Reference to member var_array_bitset
     */
    eProsima_user_DllExport std::array<InnerBitsetHelper, size_1+5>& var_array_bitset()
    {
        return m_var_array_bitset;
    }



private:

    std::array<InnerBitsetHelper, size_1+5> m_var_array_bitset;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsShort(
            const ArrayMultiDimensionLiteralsShort& x)
    {
                    m_var_array_short = x.m_var_array_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsShort(
            ArrayMultiDimensionLiteralsShort&& x) noexcept
    {
        m_var_array_short = std::move(x.m_var_array_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsShort& operator =(
            const ArrayMultiDimensionLiteralsShort& x)
    {

                    m_var_array_short = x.m_var_array_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsShort& operator =(
            ArrayMultiDimensionLiteralsShort&& x) noexcept
    {

        m_var_array_short = std::move(x.m_var_array_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsShort& x) const
    {
        return (m_var_array_short == x.m_var_array_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short
     * @param _var_array_short New value to be copied in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            const std::array<std::array<std::array<int16_t, size_2>, 5+5>, size_1>& _var_array_short)
    {
        m_var_array_short = _var_array_short;
    }

    /*!
     * @brief This function moves the value in member var_array_short
     * @param _var_array_short New value to be moved in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            std::array<std::array<std::array<int16_t, size_2>, 5+5>, size_1>&& _var_array_short)
    {
        m_var_array_short = std::move(_var_array_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short
     * @return Constant reference to member var_array_short
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int16_t, size_2>, 5+5>, size_1>& var_array_short() const
    {
        return m_var_array_short;
    }

    /*!
     * @brief This function returns a reference to member var_array_short
     * @return Reference to member var_array_short
     */
    eProsima_user_DllExport std::array<std::array<std::array<int16_t, size_2>, 5+5>, size_1>& var_array_short()
    {
        return m_var_array_short;
    }



private:

    std::array<std::array<std::array<int16_t, size_2>, 5+5>, size_1> m_var_array_short{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsUShort defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsUShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsUShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUShort(
            const ArrayMultiDimensionLiteralsUShort& x)
    {
                    m_var_array_ushort = x.m_var_array_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUShort(
            ArrayMultiDimensionLiteralsUShort&& x) noexcept
    {
        m_var_array_ushort = std::move(x.m_var_array_ushort);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUShort& operator =(
            const ArrayMultiDimensionLiteralsUShort& x)
    {

                    m_var_array_ushort = x.m_var_array_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUShort that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUShort& operator =(
            ArrayMultiDimensionLiteralsUShort&& x) noexcept
    {

        m_var_array_ushort = std::move(x.m_var_array_ushort);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsUShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsUShort& x) const
    {
        return (m_var_array_ushort == x.m_var_array_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsUShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsUShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ushort
     * @param _var_array_ushort New value to be copied in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            const std::array<std::array<std::array<uint16_t, 5>, size_1*2>, size_1>& _var_array_ushort)
    {
        m_var_array_ushort = _var_array_ushort;
    }

    /*!
     * @brief This function moves the value in member var_array_ushort
     * @param _var_array_ushort New value to be moved in member var_array_ushort
     */
    eProsima_user_DllExport void var_array_ushort(
            std::array<std::array<std::array<uint16_t, 5>, size_1*2>, size_1>&& _var_array_ushort)
    {
        m_var_array_ushort = std::move(_var_array_ushort);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ushort
     * @return Constant reference to member var_array_ushort
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint16_t, 5>, size_1*2>, size_1>& var_array_ushort() const
    {
        return m_var_array_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_array_ushort
     * @return Reference to member var_array_ushort
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint16_t, 5>, size_1*2>, size_1>& var_array_ushort()
    {
        return m_var_array_ushort;
    }



private:

    std::array<std::array<std::array<uint16_t, 5>, size_1*2>, size_1> m_var_array_ushort{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLong(
            const ArrayMultiDimensionLiteralsLong& x)
    {
                    m_var_array_long = x.m_var_array_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLong(
            ArrayMultiDimensionLiteralsLong&& x) noexcept
    {
        m_var_array_long = std::move(x.m_var_array_long);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLong& operator =(
            const ArrayMultiDimensionLiteralsLong& x)
    {

                    m_var_array_long = x.m_var_array_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLong& operator =(
            ArrayMultiDimensionLiteralsLong&& x) noexcept
    {

        m_var_array_long = std::move(x.m_var_array_long);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsLong& x) const
    {
        return (m_var_array_long == x.m_var_array_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_long
     * @param _var_array_long New value to be copied in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            const std::array<std::array<std::array<int32_t, 5>, size_1>, 5*2>& _var_array_long)
    {
        m_var_array_long = _var_array_long;
    }

    /*!
     * @brief This function moves the value in member var_array_long
     * @param _var_array_long New value to be moved in member var_array_long
     */
    eProsima_user_DllExport void var_array_long(
            std::array<std::array<std::array<int32_t, 5>, size_1>, 5*2>&& _var_array_long)
    {
        m_var_array_long = std::move(_var_array_long);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_long
     * @return Constant reference to member var_array_long
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int32_t, 5>, size_1>, 5*2>& var_array_long() const
    {
        return m_var_array_long;
    }

    /*!
     * @brief This function returns a reference to member var_array_long
     * @return Reference to member var_array_long
     */
    eProsima_user_DllExport std::array<std::array<std::array<int32_t, 5>, size_1>, 5*2>& var_array_long()
    {
        return m_var_array_long;
    }



private:

    std::array<std::array<std::array<int32_t, 5>, size_1>, 5*2> m_var_array_long{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsULong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsULong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsULong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULong(
            const ArrayMultiDimensionLiteralsULong& x)
    {
                    m_var_array_ulong = x.m_var_array_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULong(
            ArrayMultiDimensionLiteralsULong&& x) noexcept
    {
        m_var_array_ulong = std::move(x.m_var_array_ulong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULong& operator =(
            const ArrayMultiDimensionLiteralsULong& x)
    {

                    m_var_array_ulong = x.m_var_array_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULong& operator =(
            ArrayMultiDimensionLiteralsULong&& x) noexcept
    {

        m_var_array_ulong = std::move(x.m_var_array_ulong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsULong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsULong& x) const
    {
        return (m_var_array_ulong == x.m_var_array_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsULong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsULong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulong
     * @param _var_array_ulong New value to be copied in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            const std::array<std::array<std::array<uint32_t, size_1>, size_1*size_2>, 5+5>& _var_array_ulong)
    {
        m_var_array_ulong = _var_array_ulong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulong
     * @param _var_array_ulong New value to be moved in member var_array_ulong
     */
    eProsima_user_DllExport void var_array_ulong(
            std::array<std::array<std::array<uint32_t, size_1>, size_1*size_2>, 5+5>&& _var_array_ulong)
    {
        m_var_array_ulong = std::move(_var_array_ulong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulong
     * @return Constant reference to member var_array_ulong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint32_t, size_1>, size_1*size_2>, 5+5>& var_array_ulong() const
    {
        return m_var_array_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulong
     * @return Reference to member var_array_ulong
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint32_t, size_1>, size_1*size_2>, 5+5>& var_array_ulong()
    {
        return m_var_array_ulong;
    }



private:

    std::array<std::array<std::array<uint32_t, size_1>, size_1*size_2>, 5+5> m_var_array_ulong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsLongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongLong(
            const ArrayMultiDimensionLiteralsLongLong& x)
    {
                    m_var_array_longlong = x.m_var_array_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongLong(
            ArrayMultiDimensionLiteralsLongLong&& x) noexcept
    {
        m_var_array_longlong = std::move(x.m_var_array_longlong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongLong& operator =(
            const ArrayMultiDimensionLiteralsLongLong& x)
    {

                    m_var_array_longlong = x.m_var_array_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongLong& operator =(
            ArrayMultiDimensionLiteralsLongLong&& x) noexcept
    {

        m_var_array_longlong = std::move(x.m_var_array_longlong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsLongLong& x) const
    {
        return (m_var_array_longlong == x.m_var_array_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longlong
     * @param _var_array_longlong New value to be copied in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            const std::array<std::array<std::array<int64_t, 5>, 5*2>, size_1>& _var_array_longlong)
    {
        m_var_array_longlong = _var_array_longlong;
    }

    /*!
     * @brief This function moves the value in member var_array_longlong
     * @param _var_array_longlong New value to be moved in member var_array_longlong
     */
    eProsima_user_DllExport void var_array_longlong(
            std::array<std::array<std::array<int64_t, 5>, 5*2>, size_1>&& _var_array_longlong)
    {
        m_var_array_longlong = std::move(_var_array_longlong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longlong
     * @return Constant reference to member var_array_longlong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<int64_t, 5>, 5*2>, size_1>& var_array_longlong() const
    {
        return m_var_array_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_array_longlong
     * @return Reference to member var_array_longlong
     */
    eProsima_user_DllExport std::array<std::array<std::array<int64_t, 5>, 5*2>, size_1>& var_array_longlong()
    {
        return m_var_array_longlong;
    }



private:

    std::array<std::array<std::array<int64_t, 5>, 5*2>, size_1> m_var_array_longlong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsULongLong defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsULongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsULongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULongLong(
            const ArrayMultiDimensionLiteralsULongLong& x)
    {
                    m_var_array_ulonglong = x.m_var_array_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULongLong(
            ArrayMultiDimensionLiteralsULongLong&& x) noexcept
    {
        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULongLong& operator =(
            const ArrayMultiDimensionLiteralsULongLong& x)
    {

                    m_var_array_ulonglong = x.m_var_array_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsULongLong that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsULongLong& operator =(
            ArrayMultiDimensionLiteralsULongLong&& x) noexcept
    {

        m_var_array_ulonglong = std::move(x.m_var_array_ulonglong);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsULongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsULongLong& x) const
    {
        return (m_var_array_ulonglong == x.m_var_array_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsULongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsULongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be copied in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            const std::array<std::array<std::array<uint64_t, 5+5>, size_1*size_2>, size_1+5>& _var_array_ulonglong)
    {
        m_var_array_ulonglong = _var_array_ulonglong;
    }

    /*!
     * @brief This function moves the value in member var_array_ulonglong
     * @param _var_array_ulonglong New value to be moved in member var_array_ulonglong
     */
    eProsima_user_DllExport void var_array_ulonglong(
            std::array<std::array<std::array<uint64_t, 5+5>, size_1*size_2>, size_1+5>&& _var_array_ulonglong)
    {
        m_var_array_ulonglong = std::move(_var_array_ulonglong);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_ulonglong
     * @return Constant reference to member var_array_ulonglong
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint64_t, 5+5>, size_1*size_2>, size_1+5>& var_array_ulonglong() const
    {
        return m_var_array_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_array_ulonglong
     * @return Reference to member var_array_ulonglong
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint64_t, 5+5>, size_1*size_2>, size_1+5>& var_array_ulonglong()
    {
        return m_var_array_ulonglong;
    }



private:

    std::array<std::array<std::array<uint64_t, 5+5>, size_1*size_2>, size_1+5> m_var_array_ulonglong{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsFloat defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsFloat(
            const ArrayMultiDimensionLiteralsFloat& x)
    {
                    m_var_array_float = x.m_var_array_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsFloat(
            ArrayMultiDimensionLiteralsFloat&& x) noexcept
    {
        m_var_array_float = std::move(x.m_var_array_float);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsFloat& operator =(
            const ArrayMultiDimensionLiteralsFloat& x)
    {

                    m_var_array_float = x.m_var_array_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsFloat that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsFloat& operator =(
            ArrayMultiDimensionLiteralsFloat&& x) noexcept
    {

        m_var_array_float = std::move(x.m_var_array_float);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsFloat& x) const
    {
        return (m_var_array_float == x.m_var_array_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_float
     * @param _var_array_float New value to be copied in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            const std::array<std::array<std::array<float, 5+5>, size_1>, 5*2>& _var_array_float)
    {
        m_var_array_float = _var_array_float;
    }

    /*!
     * @brief This function moves the value in member var_array_float
     * @param _var_array_float New value to be moved in member var_array_float
     */
    eProsima_user_DllExport void var_array_float(
            std::array<std::array<std::array<float, 5+5>, size_1>, 5*2>&& _var_array_float)
    {
        m_var_array_float = std::move(_var_array_float);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_float
     * @return Constant reference to member var_array_float
     */
    eProsima_user_DllExport const std::array<std::array<std::array<float, 5+5>, size_1>, 5*2>& var_array_float() const
    {
        return m_var_array_float;
    }

    /*!
     * @brief This function returns a reference to member var_array_float
     * @return Reference to member var_array_float
     */
    eProsima_user_DllExport std::array<std::array<std::array<float, 5+5>, size_1>, 5*2>& var_array_float()
    {
        return m_var_array_float;
    }



private:

    std::array<std::array<std::array<float, 5+5>, size_1>, 5*2> m_var_array_float{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsDouble(
            const ArrayMultiDimensionLiteralsDouble& x)
    {
                    m_var_array_double = x.m_var_array_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsDouble(
            ArrayMultiDimensionLiteralsDouble&& x) noexcept
    {
        m_var_array_double = std::move(x.m_var_array_double);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsDouble& operator =(
            const ArrayMultiDimensionLiteralsDouble& x)
    {

                    m_var_array_double = x.m_var_array_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsDouble& operator =(
            ArrayMultiDimensionLiteralsDouble&& x) noexcept
    {

        m_var_array_double = std::move(x.m_var_array_double);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsDouble& x) const
    {
        return (m_var_array_double == x.m_var_array_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_double
     * @param _var_array_double New value to be copied in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            const std::array<std::array<std::array<double, size_1>, size_1+5>, size_1>& _var_array_double)
    {
        m_var_array_double = _var_array_double;
    }

    /*!
     * @brief This function moves the value in member var_array_double
     * @param _var_array_double New value to be moved in member var_array_double
     */
    eProsima_user_DllExport void var_array_double(
            std::array<std::array<std::array<double, size_1>, size_1+5>, size_1>&& _var_array_double)
    {
        m_var_array_double = std::move(_var_array_double);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_double
     * @return Constant reference to member var_array_double
     */
    eProsima_user_DllExport const std::array<std::array<std::array<double, size_1>, size_1+5>, size_1>& var_array_double() const
    {
        return m_var_array_double;
    }

    /*!
     * @brief This function returns a reference to member var_array_double
     * @return Reference to member var_array_double
     */
    eProsima_user_DllExport std::array<std::array<std::array<double, size_1>, size_1+5>, size_1>& var_array_double()
    {
        return m_var_array_double;
    }



private:

    std::array<std::array<std::array<double, size_1>, size_1+5>, size_1> m_var_array_double{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsLongDouble defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongDouble(
            const ArrayMultiDimensionLiteralsLongDouble& x)
    {
                    m_var_array_longdouble = x.m_var_array_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongDouble(
            ArrayMultiDimensionLiteralsLongDouble&& x) noexcept
    {
        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongDouble& operator =(
            const ArrayMultiDimensionLiteralsLongDouble& x)
    {

                    m_var_array_longdouble = x.m_var_array_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsLongDouble that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsLongDouble& operator =(
            ArrayMultiDimensionLiteralsLongDouble&& x) noexcept
    {

        m_var_array_longdouble = std::move(x.m_var_array_longdouble);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsLongDouble& x) const
    {
        return (m_var_array_longdouble == x.m_var_array_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be copied in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            const std::array<std::array<std::array<long double, size_1+5>, size_1>, size_1>& _var_array_longdouble)
    {
        m_var_array_longdouble = _var_array_longdouble;
    }

    /*!
     * @brief This function moves the value in member var_array_longdouble
     * @param _var_array_longdouble New value to be moved in member var_array_longdouble
     */
    eProsima_user_DllExport void var_array_longdouble(
            std::array<std::array<std::array<long double, size_1+5>, size_1>, size_1>&& _var_array_longdouble)
    {
        m_var_array_longdouble = std::move(_var_array_longdouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_longdouble
     * @return Constant reference to member var_array_longdouble
     */
    eProsima_user_DllExport const std::array<std::array<std::array<long double, size_1+5>, size_1>, size_1>& var_array_longdouble() const
    {
        return m_var_array_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_array_longdouble
     * @return Reference to member var_array_longdouble
     */
    eProsima_user_DllExport std::array<std::array<std::array<long double, size_1+5>, size_1>, size_1>& var_array_longdouble()
    {
        return m_var_array_longdouble;
    }



private:

    std::array<std::array<std::array<long double, size_1+5>, size_1>, size_1> m_var_array_longdouble{ {{ {{0.0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsBoolean defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoolean(
            const ArrayMultiDimensionLiteralsBoolean& x)
    {
                    m_var_array_boolean = x.m_var_array_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoolean(
            ArrayMultiDimensionLiteralsBoolean&& x) noexcept
    {
        m_var_array_boolean = std::move(x.m_var_array_boolean);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoolean& operator =(
            const ArrayMultiDimensionLiteralsBoolean& x)
    {

                    m_var_array_boolean = x.m_var_array_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoolean that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoolean& operator =(
            ArrayMultiDimensionLiteralsBoolean&& x) noexcept
    {

        m_var_array_boolean = std::move(x.m_var_array_boolean);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsBoolean& x) const
    {
        return (m_var_array_boolean == x.m_var_array_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_boolean
     * @param _var_array_boolean New value to be copied in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            const std::array<std::array<std::array<bool, 5>, size_1>, size_1*size_2>& _var_array_boolean)
    {
        m_var_array_boolean = _var_array_boolean;
    }

    /*!
     * @brief This function moves the value in member var_array_boolean
     * @param _var_array_boolean New value to be moved in member var_array_boolean
     */
    eProsima_user_DllExport void var_array_boolean(
            std::array<std::array<std::array<bool, 5>, size_1>, size_1*size_2>&& _var_array_boolean)
    {
        m_var_array_boolean = std::move(_var_array_boolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_boolean
     * @return Constant reference to member var_array_boolean
     */
    eProsima_user_DllExport const std::array<std::array<std::array<bool, 5>, size_1>, size_1*size_2>& var_array_boolean() const
    {
        return m_var_array_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_array_boolean
     * @return Reference to member var_array_boolean
     */
    eProsima_user_DllExport std::array<std::array<std::array<bool, 5>, size_1>, size_1*size_2>& var_array_boolean()
    {
        return m_var_array_boolean;
    }



private:

    std::array<std::array<std::array<bool, 5>, size_1>, size_1*size_2> m_var_array_boolean{ {{ {{false}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsOctet defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsOctet(
            const ArrayMultiDimensionLiteralsOctet& x)
    {
                    m_var_array_octet = x.m_var_array_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsOctet(
            ArrayMultiDimensionLiteralsOctet&& x) noexcept
    {
        m_var_array_octet = std::move(x.m_var_array_octet);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsOctet& operator =(
            const ArrayMultiDimensionLiteralsOctet& x)
    {

                    m_var_array_octet = x.m_var_array_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsOctet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsOctet& operator =(
            ArrayMultiDimensionLiteralsOctet&& x) noexcept
    {

        m_var_array_octet = std::move(x.m_var_array_octet);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsOctet& x) const
    {
        return (m_var_array_octet == x.m_var_array_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_octet
     * @param _var_array_octet New value to be copied in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            const std::array<std::array<std::array<uint8_t, size_1>, size_1*2>, size_1>& _var_array_octet)
    {
        m_var_array_octet = _var_array_octet;
    }

    /*!
     * @brief This function moves the value in member var_array_octet
     * @param _var_array_octet New value to be moved in member var_array_octet
     */
    eProsima_user_DllExport void var_array_octet(
            std::array<std::array<std::array<uint8_t, size_1>, size_1*2>, size_1>&& _var_array_octet)
    {
        m_var_array_octet = std::move(_var_array_octet);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_octet
     * @return Constant reference to member var_array_octet
     */
    eProsima_user_DllExport const std::array<std::array<std::array<uint8_t, size_1>, size_1*2>, size_1>& var_array_octet() const
    {
        return m_var_array_octet;
    }

    /*!
     * @brief This function returns a reference to member var_array_octet
     * @return Reference to member var_array_octet
     */
    eProsima_user_DllExport std::array<std::array<std::array<uint8_t, size_1>, size_1*2>, size_1>& var_array_octet()
    {
        return m_var_array_octet;
    }



private:

    std::array<std::array<std::array<uint8_t, size_1>, size_1*2>, size_1> m_var_array_octet{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsChar(
            const ArrayMultiDimensionLiteralsChar& x)
    {
                    m_var_array_char = x.m_var_array_char;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsChar(
            ArrayMultiDimensionLiteralsChar&& x) noexcept
    {
        m_var_array_char = std::move(x.m_var_array_char);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsChar& operator =(
            const ArrayMultiDimensionLiteralsChar& x)
    {

                    m_var_array_char = x.m_var_array_char;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsChar& operator =(
            ArrayMultiDimensionLiteralsChar&& x) noexcept
    {

        m_var_array_char = std::move(x.m_var_array_char);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsChar& x) const
    {
        return (m_var_array_char == x.m_var_array_char);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_char
     * @param _var_array_char New value to be copied in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            const std::array<std::array<std::array<char, 5+5>, size_1>, 5+5>& _var_array_char)
    {
        m_var_array_char = _var_array_char;
    }

    /*!
     * @brief This function moves the value in member var_array_char
     * @param _var_array_char New value to be moved in member var_array_char
     */
    eProsima_user_DllExport void var_array_char(
            std::array<std::array<std::array<char, 5+5>, size_1>, 5+5>&& _var_array_char)
    {
        m_var_array_char = std::move(_var_array_char);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_char
     * @return Constant reference to member var_array_char
     */
    eProsima_user_DllExport const std::array<std::array<std::array<char, 5+5>, size_1>, 5+5>& var_array_char() const
    {
        return m_var_array_char;
    }

    /*!
     * @brief This function returns a reference to member var_array_char
     * @return Reference to member var_array_char
     */
    eProsima_user_DllExport std::array<std::array<std::array<char, 5+5>, size_1>, 5+5>& var_array_char()
    {
        return m_var_array_char;
    }



private:

    std::array<std::array<std::array<char, 5+5>, size_1>, 5+5> m_var_array_char{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsWChar defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsWChar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWChar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsWChar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWChar(
            const ArrayMultiDimensionLiteralsWChar& x)
    {
                    m_var_array_wchar = x.m_var_array_wchar;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWChar(
            ArrayMultiDimensionLiteralsWChar&& x) noexcept
    {
        m_var_array_wchar = std::move(x.m_var_array_wchar);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWChar& operator =(
            const ArrayMultiDimensionLiteralsWChar& x)
    {

                    m_var_array_wchar = x.m_var_array_wchar;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWChar that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWChar& operator =(
            ArrayMultiDimensionLiteralsWChar&& x) noexcept
    {

        m_var_array_wchar = std::move(x.m_var_array_wchar);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsWChar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsWChar& x) const
    {
        return (m_var_array_wchar == x.m_var_array_wchar);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsWChar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsWChar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wchar
     * @param _var_array_wchar New value to be copied in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            const std::array<std::array<std::array<wchar_t, size_1>, size_1+5>, size_1*size_2>& _var_array_wchar)
    {
        m_var_array_wchar = _var_array_wchar;
    }

    /*!
     * @brief This function moves the value in member var_array_wchar
     * @param _var_array_wchar New value to be moved in member var_array_wchar
     */
    eProsima_user_DllExport void var_array_wchar(
            std::array<std::array<std::array<wchar_t, size_1>, size_1+5>, size_1*size_2>&& _var_array_wchar)
    {
        m_var_array_wchar = std::move(_var_array_wchar);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wchar
     * @return Constant reference to member var_array_wchar
     */
    eProsima_user_DllExport const std::array<std::array<std::array<wchar_t, size_1>, size_1+5>, size_1*size_2>& var_array_wchar() const
    {
        return m_var_array_wchar;
    }

    /*!
     * @brief This function returns a reference to member var_array_wchar
     * @return Reference to member var_array_wchar
     */
    eProsima_user_DllExport std::array<std::array<std::array<wchar_t, size_1>, size_1+5>, size_1*size_2>& var_array_wchar()
    {
        return m_var_array_wchar;
    }



private:

    std::array<std::array<std::array<wchar_t, size_1>, size_1+5>, size_1*size_2> m_var_array_wchar{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsString(
            const ArrayMultiDimensionLiteralsString& x)
    {
                    m_var_array_string = x.m_var_array_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsString(
            ArrayMultiDimensionLiteralsString&& x) noexcept
    {
        m_var_array_string = std::move(x.m_var_array_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsString& operator =(
            const ArrayMultiDimensionLiteralsString& x)
    {

                    m_var_array_string = x.m_var_array_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsString& operator =(
            ArrayMultiDimensionLiteralsString&& x) noexcept
    {

        m_var_array_string = std::move(x.m_var_array_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsString& x) const
    {
        return (m_var_array_string == x.m_var_array_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_string
     * @param _var_array_string New value to be copied in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            const std::array<std::array<std::array<std::string, 5>, 5*2>, size_1>& _var_array_string)
    {
        m_var_array_string = _var_array_string;
    }

    /*!
     * @brief This function moves the value in member var_array_string
     * @param _var_array_string New value to be moved in member var_array_string
     */
    eProsima_user_DllExport void var_array_string(
            std::array<std::array<std::array<std::string, 5>, 5*2>, size_1>&& _var_array_string)
    {
        m_var_array_string = std::move(_var_array_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_string
     * @return Constant reference to member var_array_string
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::string, 5>, 5*2>, size_1>& var_array_string() const
    {
        return m_var_array_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_string
     * @return Reference to member var_array_string
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::string, 5>, 5*2>, size_1>& var_array_string()
    {
        return m_var_array_string;
    }



private:

    std::array<std::array<std::array<std::string, 5>, 5*2>, size_1> m_var_array_string;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWString(
            const ArrayMultiDimensionLiteralsWString& x)
    {
                    m_var_array_wstring = x.m_var_array_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWString(
            ArrayMultiDimensionLiteralsWString&& x) noexcept
    {
        m_var_array_wstring = std::move(x.m_var_array_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWString& operator =(
            const ArrayMultiDimensionLiteralsWString& x)
    {

                    m_var_array_wstring = x.m_var_array_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsWString& operator =(
            ArrayMultiDimensionLiteralsWString&& x) noexcept
    {

        m_var_array_wstring = std::move(x.m_var_array_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsWString& x) const
    {
        return (m_var_array_wstring == x.m_var_array_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_wstring
     * @param _var_array_wstring New value to be copied in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            const std::array<std::array<std::array<std::wstring, 5*2>, size_1*size_2>, size_1+5>& _var_array_wstring)
    {
        m_var_array_wstring = _var_array_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_wstring
     * @param _var_array_wstring New value to be moved in member var_array_wstring
     */
    eProsima_user_DllExport void var_array_wstring(
            std::array<std::array<std::array<std::wstring, 5*2>, size_1*size_2>, size_1+5>&& _var_array_wstring)
    {
        m_var_array_wstring = std::move(_var_array_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_wstring
     * @return Constant reference to member var_array_wstring
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::wstring, 5*2>, size_1*size_2>, size_1+5>& var_array_wstring() const
    {
        return m_var_array_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_wstring
     * @return Reference to member var_array_wstring
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::wstring, 5*2>, size_1*size_2>, size_1+5>& var_array_wstring()
    {
        return m_var_array_wstring;
    }



private:

    std::array<std::array<std::array<std::wstring, 5*2>, size_1*size_2>, size_1+5> m_var_array_wstring;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsBoundedString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedString(
            const ArrayMultiDimensionLiteralsBoundedString& x)
    {
                    m_var_array_bounded_string = x.m_var_array_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedString(
            ArrayMultiDimensionLiteralsBoundedString&& x) noexcept
    {
        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedString& operator =(
            const ArrayMultiDimensionLiteralsBoundedString& x)
    {

                    m_var_array_bounded_string = x.m_var_array_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedString& operator =(
            ArrayMultiDimensionLiteralsBoundedString&& x) noexcept
    {

        m_var_array_bounded_string = std::move(x.m_var_array_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsBoundedString& x) const
    {
        return (m_var_array_bounded_string == x.m_var_array_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be copied in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            const std::array<std::array<std::array<Inner_alias_bounded_string_helper, 5>, 5*2>, size_1>& _var_array_bounded_string)
    {
        m_var_array_bounded_string = _var_array_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_string
     * @param _var_array_bounded_string New value to be moved in member var_array_bounded_string
     */
    eProsima_user_DllExport void var_array_bounded_string(
            std::array<std::array<std::array<Inner_alias_bounded_string_helper, 5>, 5*2>, size_1>&& _var_array_bounded_string)
    {
        m_var_array_bounded_string = std::move(_var_array_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_string
     * @return Constant reference to member var_array_bounded_string
     */
    eProsima_user_DllExport const std::array<std::array<std::array<Inner_alias_bounded_string_helper, 5>, 5*2>, size_1>& var_array_bounded_string() const
    {
        return m_var_array_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_string
     * @return Reference to member var_array_bounded_string
     */
    eProsima_user_DllExport std::array<std::array<std::array<Inner_alias_bounded_string_helper, 5>, 5*2>, size_1>& var_array_bounded_string()
    {
        return m_var_array_bounded_string;
    }



private:

    std::array<std::array<std::array<Inner_alias_bounded_string_helper, 5>, 5*2>, size_1> m_var_array_bounded_string;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsBoundedWString defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedWString(
            const ArrayMultiDimensionLiteralsBoundedWString& x)
    {
                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedWString(
            ArrayMultiDimensionLiteralsBoundedWString&& x) noexcept
    {
        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedWString& operator =(
            const ArrayMultiDimensionLiteralsBoundedWString& x)
    {

                    m_var_array_bounded_wstring = x.m_var_array_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBoundedWString that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBoundedWString& operator =(
            ArrayMultiDimensionLiteralsBoundedWString&& x) noexcept
    {

        m_var_array_bounded_wstring = std::move(x.m_var_array_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsBoundedWString& x) const
    {
        return (m_var_array_bounded_wstring == x.m_var_array_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be copied in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            const std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 5*2>, size_1*size_2>, size_1+5>& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = _var_array_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_array_bounded_wstring
     * @param _var_array_bounded_wstring New value to be moved in member var_array_bounded_wstring
     */
    eProsima_user_DllExport void var_array_bounded_wstring(
            std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 5*2>, size_1*size_2>, size_1+5>&& _var_array_bounded_wstring)
    {
        m_var_array_bounded_wstring = std::move(_var_array_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bounded_wstring
     * @return Constant reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport const std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 5*2>, size_1*size_2>, size_1+5>& var_array_bounded_wstring() const
    {
        return m_var_array_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_array_bounded_wstring
     * @return Reference to member var_array_bounded_wstring
     */
    eProsima_user_DllExport std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 5*2>, size_1*size_2>, size_1+5>& var_array_bounded_wstring()
    {
        return m_var_array_bounded_wstring;
    }



private:

    std::array<std::array<std::array<Inner_alias_bounded_wstring_helper, 5*2>, size_1*size_2>, size_1+5> m_var_array_bounded_wstring;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsEnum defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsEnum(
            const ArrayMultiDimensionLiteralsEnum& x)
    {
                    m_var_array_enum = x.m_var_array_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsEnum(
            ArrayMultiDimensionLiteralsEnum&& x) noexcept
    {
        m_var_array_enum = std::move(x.m_var_array_enum);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsEnum& operator =(
            const ArrayMultiDimensionLiteralsEnum& x)
    {

                    m_var_array_enum = x.m_var_array_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsEnum that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsEnum& operator =(
            ArrayMultiDimensionLiteralsEnum&& x) noexcept
    {

        m_var_array_enum = std::move(x.m_var_array_enum);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsEnum& x) const
    {
        return (m_var_array_enum == x.m_var_array_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_enum
     * @param _var_array_enum New value to be copied in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            const std::array<std::array<std::array<InnerEnumHelper, 5+5>, size_1>, 5*2>& _var_array_enum)
    {
        m_var_array_enum = _var_array_enum;
    }

    /*!
     * @brief This function moves the value in member var_array_enum
     * @param _var_array_enum New value to be moved in member var_array_enum
     */
    eProsima_user_DllExport void var_array_enum(
            std::array<std::array<std::array<InnerEnumHelper, 5+5>, size_1>, 5*2>&& _var_array_enum)
    {
        m_var_array_enum = std::move(_var_array_enum);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_enum
     * @return Constant reference to member var_array_enum
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerEnumHelper, 5+5>, size_1>, 5*2>& var_array_enum() const
    {
        return m_var_array_enum;
    }

    /*!
     * @brief This function returns a reference to member var_array_enum
     * @return Reference to member var_array_enum
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerEnumHelper, 5+5>, size_1>, 5*2>& var_array_enum()
    {
        return m_var_array_enum;
    }



private:

    std::array<std::array<std::array<InnerEnumHelper, 5+5>, size_1>, 5*2> m_var_array_enum{ {{ {{InnerEnumHelper::ENUM_VALUE_1}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsBitMask defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitMask(
            const ArrayMultiDimensionLiteralsBitMask& x)
    {
                    m_var_array_bitmask = x.m_var_array_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitMask(
            ArrayMultiDimensionLiteralsBitMask&& x) noexcept
    {
        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitMask& operator =(
            const ArrayMultiDimensionLiteralsBitMask& x)
    {

                    m_var_array_bitmask = x.m_var_array_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitMask that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitMask& operator =(
            ArrayMultiDimensionLiteralsBitMask&& x) noexcept
    {

        m_var_array_bitmask = std::move(x.m_var_array_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsBitMask& x) const
    {
        return (m_var_array_bitmask == x.m_var_array_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be copied in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            const std::array<std::array<std::array<InnerBitMaskHelper, size_1>, size_1+5>, size_1>& _var_array_bitmask)
    {
        m_var_array_bitmask = _var_array_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_array_bitmask
     * @param _var_array_bitmask New value to be moved in member var_array_bitmask
     */
    eProsima_user_DllExport void var_array_bitmask(
            std::array<std::array<std::array<InnerBitMaskHelper, size_1>, size_1+5>, size_1>&& _var_array_bitmask)
    {
        m_var_array_bitmask = std::move(_var_array_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitmask
     * @return Constant reference to member var_array_bitmask
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerBitMaskHelper, size_1>, size_1+5>, size_1>& var_array_bitmask() const
    {
        return m_var_array_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitmask
     * @return Reference to member var_array_bitmask
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerBitMaskHelper, size_1>, size_1+5>, size_1>& var_array_bitmask()
    {
        return m_var_array_bitmask;
    }



private:

    std::array<std::array<std::array<InnerBitMaskHelper, size_1>, size_1+5>, size_1> m_var_array_bitmask{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsAlias defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsAlias(
            const ArrayMultiDimensionLiteralsAlias& x)
    {
                    m_var_array_alias = x.m_var_array_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsAlias(
            ArrayMultiDimensionLiteralsAlias&& x) noexcept
    {
        m_var_array_alias = std::move(x.m_var_array_alias);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsAlias& operator =(
            const ArrayMultiDimensionLiteralsAlias& x)
    {

                    m_var_array_alias = x.m_var_array_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsAlias that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsAlias& operator =(
            ArrayMultiDimensionLiteralsAlias&& x) noexcept
    {

        m_var_array_alias = std::move(x.m_var_array_alias);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsAlias& x) const
    {
        return (m_var_array_alias == x.m_var_array_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_alias
     * @param _var_array_alias New value to be copied in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            const std::array<std::array<std::array<InnerAliasHelper, size_1*size_2>, 5*2>, size_1*2>& _var_array_alias)
    {
        m_var_array_alias = _var_array_alias;
    }

    /*!
     * @brief This function moves the value in member var_array_alias
     * @param _var_array_alias New value to be moved in member var_array_alias
     */
    eProsima_user_DllExport void var_array_alias(
            std::array<std::array<std::array<InnerAliasHelper, size_1*size_2>, 5*2>, size_1*2>&& _var_array_alias)
    {
        m_var_array_alias = std::move(_var_array_alias);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_alias
     * @return Constant reference to member var_array_alias
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerAliasHelper, size_1*size_2>, 5*2>, size_1*2>& var_array_alias() const
    {
        return m_var_array_alias;
    }

    /*!
     * @brief This function returns a reference to member var_array_alias
     * @return Reference to member var_array_alias
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerAliasHelper, size_1*size_2>, 5*2>, size_1*2>& var_array_alias()
    {
        return m_var_array_alias;
    }



private:

    std::array<std::array<std::array<InnerAliasHelper, size_1*size_2>, 5*2>, size_1*2> m_var_array_alias{ {{ {{0}} }} };

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsSequence defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsSequence(
            const ArrayMultiDimensionLiteralsSequence& x)
    {
                    m_var_array_sequence = x.m_var_array_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsSequence(
            ArrayMultiDimensionLiteralsSequence&& x) noexcept
    {
        m_var_array_sequence = std::move(x.m_var_array_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsSequence& operator =(
            const ArrayMultiDimensionLiteralsSequence& x)
    {

                    m_var_array_sequence = x.m_var_array_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsSequence that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsSequence& operator =(
            ArrayMultiDimensionLiteralsSequence&& x) noexcept
    {

        m_var_array_sequence = std::move(x.m_var_array_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsSequence& x) const
    {
        return (m_var_array_sequence == x.m_var_array_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_sequence
     * @param _var_array_sequence New value to be copied in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            const std::array<std::array<std::array<std::vector<int32_t>, 5*2>, size_1>, size_1+5>& _var_array_sequence)
    {
        m_var_array_sequence = _var_array_sequence;
    }

    /*!
     * @brief This function moves the value in member var_array_sequence
     * @param _var_array_sequence New value to be moved in member var_array_sequence
     */
    eProsima_user_DllExport void var_array_sequence(
            std::array<std::array<std::array<std::vector<int32_t>, 5*2>, size_1>, size_1+5>&& _var_array_sequence)
    {
        m_var_array_sequence = std::move(_var_array_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_sequence
     * @return Constant reference to member var_array_sequence
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::vector<int32_t>, 5*2>, size_1>, size_1+5>& var_array_sequence() const
    {
        return m_var_array_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_array_sequence
     * @return Reference to member var_array_sequence
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::vector<int32_t>, 5*2>, size_1>, size_1+5>& var_array_sequence()
    {
        return m_var_array_sequence;
    }



private:

    std::array<std::array<std::array<std::vector<int32_t>, 5*2>, size_1>, size_1+5> m_var_array_sequence;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsMap defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsMap(
            const ArrayMultiDimensionLiteralsMap& x)
    {
                    m_var_array_map = x.m_var_array_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsMap(
            ArrayMultiDimensionLiteralsMap&& x) noexcept
    {
        m_var_array_map = std::move(x.m_var_array_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsMap& operator =(
            const ArrayMultiDimensionLiteralsMap& x)
    {

                    m_var_array_map = x.m_var_array_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsMap that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsMap& operator =(
            ArrayMultiDimensionLiteralsMap&& x) noexcept
    {

        m_var_array_map = std::move(x.m_var_array_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsMap& x) const
    {
        return (m_var_array_map == x.m_var_array_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_map
     * @param _var_array_map New value to be copied in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            const std::array<std::array<std::array<std::map<int32_t, int32_t>, size_1>, size_1*2>, size_1>& _var_array_map)
    {
        m_var_array_map = _var_array_map;
    }

    /*!
     * @brief This function moves the value in member var_array_map
     * @param _var_array_map New value to be moved in member var_array_map
     */
    eProsima_user_DllExport void var_array_map(
            std::array<std::array<std::array<std::map<int32_t, int32_t>, size_1>, size_1*2>, size_1>&& _var_array_map)
    {
        m_var_array_map = std::move(_var_array_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_map
     * @return Constant reference to member var_array_map
     */
    eProsima_user_DllExport const std::array<std::array<std::array<std::map<int32_t, int32_t>, size_1>, size_1*2>, size_1>& var_array_map() const
    {
        return m_var_array_map;
    }

    /*!
     * @brief This function returns a reference to member var_array_map
     * @return Reference to member var_array_map
     */
    eProsima_user_DllExport std::array<std::array<std::array<std::map<int32_t, int32_t>, size_1>, size_1*2>, size_1>& var_array_map()
    {
        return m_var_array_map;
    }



private:

    std::array<std::array<std::array<std::map<int32_t, int32_t>, size_1>, size_1*2>, size_1> m_var_array_map;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsUnion defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUnion(
            const ArrayMultiDimensionLiteralsUnion& x)
    {
                    m_var_array_union = x.m_var_array_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUnion(
            ArrayMultiDimensionLiteralsUnion&& x) noexcept
    {
        m_var_array_union = std::move(x.m_var_array_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUnion& operator =(
            const ArrayMultiDimensionLiteralsUnion& x)
    {

                    m_var_array_union = x.m_var_array_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsUnion that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsUnion& operator =(
            ArrayMultiDimensionLiteralsUnion&& x) noexcept
    {

        m_var_array_union = std::move(x.m_var_array_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsUnion& x) const
    {
        return (m_var_array_union == x.m_var_array_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_union
     * @param _var_array_union New value to be copied in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            const std::array<std::array<std::array<InnerUnionHelper, size_1*2>, size_1+5>, size_1*size_2>& _var_array_union)
    {
        m_var_array_union = _var_array_union;
    }

    /*!
     * @brief This function moves the value in member var_array_union
     * @param _var_array_union New value to be moved in member var_array_union
     */
    eProsima_user_DllExport void var_array_union(
            std::array<std::array<std::array<InnerUnionHelper, size_1*2>, size_1+5>, size_1*size_2>&& _var_array_union)
    {
        m_var_array_union = std::move(_var_array_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_union
     * @return Constant reference to member var_array_union
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerUnionHelper, size_1*2>, size_1+5>, size_1*size_2>& var_array_union() const
    {
        return m_var_array_union;
    }

    /*!
     * @brief This function returns a reference to member var_array_union
     * @return Reference to member var_array_union
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerUnionHelper, size_1*2>, size_1+5>, size_1*size_2>& var_array_union()
    {
        return m_var_array_union;
    }



private:

    std::array<std::array<std::array<InnerUnionHelper, size_1*2>, size_1+5>, size_1*size_2> m_var_array_union;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsStructure defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsStructure(
            const ArrayMultiDimensionLiteralsStructure& x)
    {
                    m_var_array_structure = x.m_var_array_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsStructure(
            ArrayMultiDimensionLiteralsStructure&& x) noexcept
    {
        m_var_array_structure = std::move(x.m_var_array_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsStructure& operator =(
            const ArrayMultiDimensionLiteralsStructure& x)
    {

                    m_var_array_structure = x.m_var_array_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsStructure that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsStructure& operator =(
            ArrayMultiDimensionLiteralsStructure&& x) noexcept
    {

        m_var_array_structure = std::move(x.m_var_array_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsStructure& x) const
    {
        return (m_var_array_structure == x.m_var_array_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_structure
     * @param _var_array_structure New value to be copied in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            const std::array<std::array<std::array<InnerStructureHelper, size_1+5>, size_1>, 5>& _var_array_structure)
    {
        m_var_array_structure = _var_array_structure;
    }

    /*!
     * @brief This function moves the value in member var_array_structure
     * @param _var_array_structure New value to be moved in member var_array_structure
     */
    eProsima_user_DllExport void var_array_structure(
            std::array<std::array<std::array<InnerStructureHelper, size_1+5>, size_1>, 5>&& _var_array_structure)
    {
        m_var_array_structure = std::move(_var_array_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_structure
     * @return Constant reference to member var_array_structure
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerStructureHelper, size_1+5>, size_1>, 5>& var_array_structure() const
    {
        return m_var_array_structure;
    }

    /*!
     * @brief This function returns a reference to member var_array_structure
     * @return Reference to member var_array_structure
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerStructureHelper, size_1+5>, size_1>, 5>& var_array_structure()
    {
        return m_var_array_structure;
    }



private:

    std::array<std::array<std::array<InnerStructureHelper, size_1+5>, size_1>, 5> m_var_array_structure;

};
/*!
 * @brief This class represents the structure ArrayMultiDimensionLiteralsBitSet defined by the user in the IDL file.
 * @ingroup arrays
 */
class ArrayMultiDimensionLiteralsBitSet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitSet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ArrayMultiDimensionLiteralsBitSet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitSet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitSet(
            const ArrayMultiDimensionLiteralsBitSet& x)
    {
                    m_var_array_bitset = x.m_var_array_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitSet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitSet(
            ArrayMultiDimensionLiteralsBitSet&& x) noexcept
    {
        m_var_array_bitset = std::move(x.m_var_array_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitSet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitSet& operator =(
            const ArrayMultiDimensionLiteralsBitSet& x)
    {

                    m_var_array_bitset = x.m_var_array_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ArrayMultiDimensionLiteralsBitSet that will be copied.
     */
    eProsima_user_DllExport ArrayMultiDimensionLiteralsBitSet& operator =(
            ArrayMultiDimensionLiteralsBitSet&& x) noexcept
    {

        m_var_array_bitset = std::move(x.m_var_array_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBitSet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ArrayMultiDimensionLiteralsBitSet& x) const
    {
        return (m_var_array_bitset == x.m_var_array_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x ArrayMultiDimensionLiteralsBitSet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ArrayMultiDimensionLiteralsBitSet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_bitset
     * @param _var_array_bitset New value to be copied in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            const std::array<std::array<std::array<InnerBitsetHelper, size_1*size_2>, size_1*2>, size_1+5>& _var_array_bitset)
    {
        m_var_array_bitset = _var_array_bitset;
    }

    /*!
     * @brief This function moves the value in member var_array_bitset
     * @param _var_array_bitset New value to be moved in member var_array_bitset
     */
    eProsima_user_DllExport void var_array_bitset(
            std::array<std::array<std::array<InnerBitsetHelper, size_1*size_2>, size_1*2>, size_1+5>&& _var_array_bitset)
    {
        m_var_array_bitset = std::move(_var_array_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_bitset
     * @return Constant reference to member var_array_bitset
     */
    eProsima_user_DllExport const std::array<std::array<std::array<InnerBitsetHelper, size_1*size_2>, size_1*2>, size_1+5>& var_array_bitset() const
    {
        return m_var_array_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_array_bitset
     * @return Reference to member var_array_bitset
     */
    eProsima_user_DllExport std::array<std::array<std::array<InnerBitsetHelper, size_1*size_2>, size_1*2>, size_1+5>& var_array_bitset()
    {
        return m_var_array_bitset;
    }



private:

    std::array<std::array<std::array<InnerBitsetHelper, size_1*size_2>, size_1*2>, size_1+5> m_var_array_bitset;

};
/*!
 * @brief This class represents the structure BoundedSmallArrays defined by the user in the IDL file.
 * @ingroup arrays
 */
class BoundedSmallArrays
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BoundedSmallArrays()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BoundedSmallArrays()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BoundedSmallArrays that will be copied.
     */
    eProsima_user_DllExport BoundedSmallArrays(
            const BoundedSmallArrays& x)
    {
                    m_var_array_small = x.m_var_array_small;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BoundedSmallArrays that will be copied.
     */
    eProsima_user_DllExport BoundedSmallArrays(
            BoundedSmallArrays&& x) noexcept
    {
        m_var_array_small = std::move(x.m_var_array_small);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BoundedSmallArrays that will be copied.
     */
    eProsima_user_DllExport BoundedSmallArrays& operator =(
            const BoundedSmallArrays& x)
    {

                    m_var_array_small = x.m_var_array_small;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BoundedSmallArrays that will be copied.
     */
    eProsima_user_DllExport BoundedSmallArrays& operator =(
            BoundedSmallArrays&& x) noexcept
    {

        m_var_array_small = std::move(x.m_var_array_small);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedSmallArrays object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BoundedSmallArrays& x) const
    {
        return (m_var_array_small == x.m_var_array_small);
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedSmallArrays object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BoundedSmallArrays& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_small
     * @param _var_array_small New value to be copied in member var_array_small
     */
    eProsima_user_DllExport void var_array_small(
            const std::array<int16_t, 1>& _var_array_small)
    {
        m_var_array_small = _var_array_small;
    }

    /*!
     * @brief This function moves the value in member var_array_small
     * @param _var_array_small New value to be moved in member var_array_small
     */
    eProsima_user_DllExport void var_array_small(
            std::array<int16_t, 1>&& _var_array_small)
    {
        m_var_array_small = std::move(_var_array_small);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_small
     * @return Constant reference to member var_array_small
     */
    eProsima_user_DllExport const std::array<int16_t, 1>& var_array_small() const
    {
        return m_var_array_small;
    }

    /*!
     * @brief This function returns a reference to member var_array_small
     * @return Reference to member var_array_small
     */
    eProsima_user_DllExport std::array<int16_t, 1>& var_array_small()
    {
        return m_var_array_small;
    }



private:

    std::array<int16_t, 1> m_var_array_small{0};

};
/*!
 * @brief This class represents the structure BoundedBigArrays defined by the user in the IDL file.
 * @ingroup arrays
 */
class BoundedBigArrays
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BoundedBigArrays()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BoundedBigArrays()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BoundedBigArrays that will be copied.
     */
    eProsima_user_DllExport BoundedBigArrays(
            const BoundedBigArrays& x)
    {
                    m_var_array_big = x.m_var_array_big;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BoundedBigArrays that will be copied.
     */
    eProsima_user_DllExport BoundedBigArrays(
            BoundedBigArrays&& x) noexcept
    {
        m_var_array_big = std::move(x.m_var_array_big);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BoundedBigArrays that will be copied.
     */
    eProsima_user_DllExport BoundedBigArrays& operator =(
            const BoundedBigArrays& x)
    {

                    m_var_array_big = x.m_var_array_big;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BoundedBigArrays that will be copied.
     */
    eProsima_user_DllExport BoundedBigArrays& operator =(
            BoundedBigArrays&& x) noexcept
    {

        m_var_array_big = std::move(x.m_var_array_big);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBigArrays object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BoundedBigArrays& x) const
    {
        return (m_var_array_big == x.m_var_array_big);
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBigArrays object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BoundedBigArrays& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_big
     * @param _var_array_big New value to be copied in member var_array_big
     */
    eProsima_user_DllExport void var_array_big(
            const std::array<int16_t, 41925>& _var_array_big)
    {
        m_var_array_big = _var_array_big;
    }

    /*!
     * @brief This function moves the value in member var_array_big
     * @param _var_array_big New value to be moved in member var_array_big
     */
    eProsima_user_DllExport void var_array_big(
            std::array<int16_t, 41925>&& _var_array_big)
    {
        m_var_array_big = std::move(_var_array_big);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_big
     * @return Constant reference to member var_array_big
     */
    eProsima_user_DllExport const std::array<int16_t, 41925>& var_array_big() const
    {
        return m_var_array_big;
    }

    /*!
     * @brief This function returns a reference to member var_array_big
     * @return Reference to member var_array_big
     */
    eProsima_user_DllExport std::array<int16_t, 41925>& var_array_big()
    {
        return m_var_array_big;
    }



private:

    std::array<int16_t, 41925> m_var_array_big{0};

};

#endif // _FAST_DDS_GENERATED_ARRAYS_HPP_


