// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file struct_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "struct_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "struct_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_GrandparentStruct_type_identifier(
        TypeIdentifierPair& type_ids_GrandparentStruct)
{

    ReturnCode_t return_code_GrandparentStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_GrandparentStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "GrandparentStruct", type_ids_GrandparentStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_GrandparentStruct)
    {
        StructTypeFlag struct_flags_GrandparentStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_GrandparentStruct = "GrandparentStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_GrandparentStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_GrandparentStruct;
        AppliedAnnotationSeq tmp_ann_custom_GrandparentStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_GrandparentStruct;
        if (!tmp_ann_custom_GrandparentStruct.empty())
        {
            ann_custom_GrandparentStruct = tmp_ann_custom_GrandparentStruct;
        }

        CompleteTypeDetail detail_GrandparentStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_GrandparentStruct, ann_custom_GrandparentStruct, type_name_GrandparentStruct.to_string());
        CompleteStructHeader header_GrandparentStruct;
        header_GrandparentStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_GrandparentStruct);
        CompleteStructMemberSeq member_seq_GrandparentStruct;
        {
            TypeIdentifierPair type_ids_my_long;
            ReturnCode_t return_code_my_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_my_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_long = 0x00000000;
            bool common_my_long_ec {false};
            CommonStructMember common_my_long {TypeObjectUtils::build_common_struct_member(member_id_my_long, member_flags_my_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_long, common_my_long_ec))};
            if (!common_my_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_long = "my_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_long;
            ann_custom_GrandparentStruct.reset();
            CompleteMemberDetail detail_my_long = TypeObjectUtils::build_complete_member_detail(name_my_long, member_ann_builtin_my_long, ann_custom_GrandparentStruct);
            CompleteStructMember member_my_long = TypeObjectUtils::build_complete_struct_member(common_my_long, detail_my_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_GrandparentStruct, member_my_long);
        }
        CompleteStructType struct_type_GrandparentStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_GrandparentStruct, header_GrandparentStruct, member_seq_GrandparentStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_GrandparentStruct, type_name_GrandparentStruct.to_string(), type_ids_GrandparentStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "GrandparentStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ParentStruct_type_identifier(
        TypeIdentifierPair& type_ids_ParentStruct)
{

    ReturnCode_t return_code_ParentStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ParentStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ParentStruct", type_ids_ParentStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ParentStruct)
    {
        StructTypeFlag struct_flags_ParentStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_ParentStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "GrandparentStruct", type_ids_ParentStruct);

        if (return_code_ParentStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_GrandparentStruct_type_identifier(type_ids_ParentStruct);
        }
        QualifiedTypeName type_name_ParentStruct = "ParentStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ParentStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ParentStruct;
        AppliedAnnotationSeq tmp_ann_custom_ParentStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_ParentStruct;
        if (!tmp_ann_custom_ParentStruct.empty())
        {
            ann_custom_ParentStruct = tmp_ann_custom_ParentStruct;
        }

        CompleteTypeDetail detail_ParentStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ParentStruct, ann_custom_ParentStruct, type_name_ParentStruct.to_string());
        CompleteStructHeader header_ParentStruct;
        if (EK_COMPLETE == type_ids_ParentStruct.type_identifier1()._d())
        {
            header_ParentStruct = TypeObjectUtils::build_complete_struct_header(type_ids_ParentStruct.type_identifier1(), detail_ParentStruct);
        }
        else if (EK_COMPLETE == type_ids_ParentStruct.type_identifier2()._d())
        {
            header_ParentStruct = TypeObjectUtils::build_complete_struct_header(type_ids_ParentStruct.type_identifier2(), detail_ParentStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ParentStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_ParentStruct;
        {
            TypeIdentifierPair type_ids_my_short;
            ReturnCode_t return_code_my_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_my_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_short = 0x00000001;
            bool common_my_short_ec {false};
            CommonStructMember common_my_short {TypeObjectUtils::build_common_struct_member(member_id_my_short, member_flags_my_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_short, common_my_short_ec))};
            if (!common_my_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_short = "my_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_short;
            ann_custom_ParentStruct.reset();
            CompleteMemberDetail detail_my_short = TypeObjectUtils::build_complete_member_detail(name_my_short, member_ann_builtin_my_short, ann_custom_ParentStruct);
            CompleteStructMember member_my_short = TypeObjectUtils::build_complete_struct_member(common_my_short, detail_my_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_ParentStruct, member_my_short);
        }
        {
            TypeIdentifierPair type_ids_my_string;
            ReturnCode_t return_code_my_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_my_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_string)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_my_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_my_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_string = 0x00000002;
            bool common_my_string_ec {false};
            CommonStructMember common_my_string {TypeObjectUtils::build_common_struct_member(member_id_my_string, member_flags_my_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_string, common_my_string_ec))};
            if (!common_my_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_string = "my_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_string;
            ann_custom_ParentStruct.reset();
            CompleteMemberDetail detail_my_string = TypeObjectUtils::build_complete_member_detail(name_my_string, member_ann_builtin_my_string, ann_custom_ParentStruct);
            CompleteStructMember member_my_string = TypeObjectUtils::build_complete_struct_member(common_my_string, detail_my_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_ParentStruct, member_my_string);
        }
        {
            TypeIdentifierPair type_ids_my_grandparent;
            ReturnCode_t return_code_my_grandparent {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_grandparent =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "GrandparentStruct", type_ids_my_grandparent);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_grandparent)
            {
            ::register_GrandparentStruct_type_identifier(type_ids_my_grandparent);
            }
            StructMemberFlag member_flags_my_grandparent = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_grandparent = 0x00000003;
            bool common_my_grandparent_ec {false};
            CommonStructMember common_my_grandparent {TypeObjectUtils::build_common_struct_member(member_id_my_grandparent, member_flags_my_grandparent, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_grandparent, common_my_grandparent_ec))};
            if (!common_my_grandparent_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_grandparent member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_grandparent = "my_grandparent";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_grandparent;
            ann_custom_ParentStruct.reset();
            CompleteMemberDetail detail_my_grandparent = TypeObjectUtils::build_complete_member_detail(name_my_grandparent, member_ann_builtin_my_grandparent, ann_custom_ParentStruct);
            CompleteStructMember member_my_grandparent = TypeObjectUtils::build_complete_struct_member(common_my_grandparent, detail_my_grandparent);
            TypeObjectUtils::add_complete_struct_member(member_seq_ParentStruct, member_my_grandparent);
        }
        CompleteStructType struct_type_ParentStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ParentStruct, header_ParentStruct, member_seq_ParentStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ParentStruct, type_name_ParentStruct.to_string(), type_ids_ParentStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ParentStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_NestedStructElement_type_identifier(
        TypeIdentifierPair& type_ids_NestedStructElement)
{

    ReturnCode_t return_code_NestedStructElement {eprosima::fastdds::dds::RETCODE_OK};
    return_code_NestedStructElement =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "NestedStructElement", type_ids_NestedStructElement);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_NestedStructElement)
    {
        StructTypeFlag struct_flags_NestedStructElement = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_NestedStructElement = "NestedStructElement";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_NestedStructElement;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_NestedStructElement;
        AppliedAnnotationSeq tmp_ann_custom_NestedStructElement;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_NestedStructElement;
        if (!tmp_ann_custom_NestedStructElement.empty())
        {
            ann_custom_NestedStructElement = tmp_ann_custom_NestedStructElement;
        }

        CompleteTypeDetail detail_NestedStructElement = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_NestedStructElement, ann_custom_NestedStructElement, type_name_NestedStructElement.to_string());
        CompleteStructHeader header_NestedStructElement;
        header_NestedStructElement = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_NestedStructElement);
        CompleteStructMemberSeq member_seq_NestedStructElement;
        {
            TypeIdentifierPair type_ids_my_boolean;
            ReturnCode_t return_code_my_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_my_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_boolean = 0x00000000;
            bool common_my_boolean_ec {false};
            CommonStructMember common_my_boolean {TypeObjectUtils::build_common_struct_member(member_id_my_boolean, member_flags_my_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_boolean, common_my_boolean_ec))};
            if (!common_my_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_boolean = "my_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_boolean;
            ann_custom_NestedStructElement.reset();
            CompleteMemberDetail detail_my_boolean = TypeObjectUtils::build_complete_member_detail(name_my_boolean, member_ann_builtin_my_boolean, ann_custom_NestedStructElement);
            CompleteStructMember member_my_boolean = TypeObjectUtils::build_complete_struct_member(common_my_boolean, detail_my_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_NestedStructElement, member_my_boolean);
        }
        CompleteStructType struct_type_NestedStructElement = TypeObjectUtils::build_complete_struct_type(struct_flags_NestedStructElement, header_NestedStructElement, member_seq_NestedStructElement);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_NestedStructElement, type_name_NestedStructElement.to_string(), type_ids_NestedStructElement))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "NestedStructElement already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructStruct_type_identifier(
        TypeIdentifierPair& type_ids_StructStruct)
{

    ReturnCode_t return_code_StructStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructStruct", type_ids_StructStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructStruct)
    {
        StructTypeFlag struct_flags_StructStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        return_code_StructStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "ParentStruct", type_ids_StructStruct);

        if (return_code_StructStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_ParentStruct_type_identifier(type_ids_StructStruct);
        }
        QualifiedTypeName type_name_StructStruct = "StructStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructStruct;
        AppliedAnnotationSeq tmp_ann_custom_StructStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_StructStruct;
        if (!tmp_ann_custom_StructStruct.empty())
        {
            ann_custom_StructStruct = tmp_ann_custom_StructStruct;
        }

        CompleteTypeDetail detail_StructStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructStruct, ann_custom_StructStruct, type_name_StructStruct.to_string());
        CompleteStructHeader header_StructStruct;
        if (EK_COMPLETE == type_ids_StructStruct.type_identifier1()._d())
        {
            header_StructStruct = TypeObjectUtils::build_complete_struct_header(type_ids_StructStruct.type_identifier1(), detail_StructStruct);
        }
        else if (EK_COMPLETE == type_ids_StructStruct.type_identifier2()._d())
        {
            header_StructStruct = TypeObjectUtils::build_complete_struct_header(type_ids_StructStruct.type_identifier2(), detail_StructStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_StructStruct;
        {
            TypeIdentifierPair type_ids_my_nested_element;
            ReturnCode_t return_code_my_nested_element {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_nested_element =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "NestedStructElement", type_ids_my_nested_element);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_nested_element)
            {
            ::register_NestedStructElement_type_identifier(type_ids_my_nested_element);
            }
            StructMemberFlag member_flags_my_nested_element = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_nested_element = 0x00000004;
            bool common_my_nested_element_ec {false};
            CommonStructMember common_my_nested_element {TypeObjectUtils::build_common_struct_member(member_id_my_nested_element, member_flags_my_nested_element, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_nested_element, common_my_nested_element_ec))};
            if (!common_my_nested_element_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_nested_element member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_nested_element = "my_nested_element";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_nested_element;
            ann_custom_StructStruct.reset();
            CompleteMemberDetail detail_my_nested_element = TypeObjectUtils::build_complete_member_detail(name_my_nested_element, member_ann_builtin_my_nested_element, ann_custom_StructStruct);
            CompleteStructMember member_my_nested_element = TypeObjectUtils::build_complete_struct_member(common_my_nested_element, detail_my_nested_element);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructStruct, member_my_nested_element);
        }
        {
            TypeIdentifierPair type_ids_my_char;
            ReturnCode_t return_code_my_char {eprosima::fastdds::dds::RETCODE_OK};
            return_code_my_char =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_my_char);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_my_char)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "my_char Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_my_char = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_my_char = 0x00000005;
            bool common_my_char_ec {false};
            CommonStructMember common_my_char {TypeObjectUtils::build_common_struct_member(member_id_my_char, member_flags_my_char, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_my_char, common_my_char_ec))};
            if (!common_my_char_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure my_char member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_my_char = "my_char";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_my_char;
            ann_custom_StructStruct.reset();
            CompleteMemberDetail detail_my_char = TypeObjectUtils::build_complete_member_detail(name_my_char, member_ann_builtin_my_char, ann_custom_StructStruct);
            CompleteStructMember member_my_char = TypeObjectUtils::build_complete_struct_member(common_my_char, detail_my_char);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructStruct, member_my_char);
        }
        CompleteStructType struct_type_StructStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_StructStruct, header_StructStruct, member_seq_StructStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructStruct, type_name_StructStruct.to_string(), type_ids_StructStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
