// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ComprehensiveTypeCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__COMPREHENSIVETYPECDRAUX_IPP
#define FAST_DDS_GENERATED__COMPREHENSIVETYPECDRAUX_IPP

#include "ComprehensiveTypeCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const PrimitivesStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.my_bool(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.my_octet(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.my_char(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.my_wchar(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.my_long(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.my_ulong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.my_int8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.my_uint8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.my_short(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.my_ushort(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.my_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.my_ulonglong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.my_float(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.my_double(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.my_longdouble(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const PrimitivesStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.my_bool()
        << eprosima::fastcdr::MemberId(1) << data.my_octet()
        << eprosima::fastcdr::MemberId(2) << data.my_char()
        << eprosima::fastcdr::MemberId(3) << data.my_wchar()
        << eprosima::fastcdr::MemberId(4) << data.my_long()
        << eprosima::fastcdr::MemberId(5) << data.my_ulong()
        << eprosima::fastcdr::MemberId(6) << data.my_int8()
        << eprosima::fastcdr::MemberId(7) << data.my_uint8()
        << eprosima::fastcdr::MemberId(8) << data.my_short()
        << eprosima::fastcdr::MemberId(9) << data.my_ushort()
        << eprosima::fastcdr::MemberId(10) << data.my_longlong()
        << eprosima::fastcdr::MemberId(11) << data.my_ulonglong()
        << eprosima::fastcdr::MemberId(12) << data.my_float()
        << eprosima::fastcdr::MemberId(13) << data.my_double()
        << eprosima::fastcdr::MemberId(14) << data.my_longdouble()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        PrimitivesStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.my_bool();
                                            break;

                                        case 1:
                                                dcdr >> data.my_octet();
                                            break;

                                        case 2:
                                                dcdr >> data.my_char();
                                            break;

                                        case 3:
                                                dcdr >> data.my_wchar();
                                            break;

                                        case 4:
                                                dcdr >> data.my_long();
                                            break;

                                        case 5:
                                                dcdr >> data.my_ulong();
                                            break;

                                        case 6:
                                                dcdr >> data.my_int8();
                                            break;

                                        case 7:
                                                dcdr >> data.my_uint8();
                                            break;

                                        case 8:
                                                dcdr >> data.my_short();
                                            break;

                                        case 9:
                                                dcdr >> data.my_ushort();
                                            break;

                                        case 10:
                                                dcdr >> data.my_longlong();
                                            break;

                                        case 11:
                                                dcdr >> data.my_ulonglong();
                                            break;

                                        case 12:
                                                dcdr >> data.my_float();
                                            break;

                                        case 13:
                                                dcdr >> data.my_double();
                                            break;

                                        case 14:
                                                dcdr >> data.my_longdouble();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const PrimitivesStruct& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.my_bool();

                        scdr << data.my_octet();

                        scdr << data.my_char();

                        scdr << data.my_wchar();

                        scdr << data.my_long();

                        scdr << data.my_ulong();

                        scdr << data.my_int8();

                        scdr << data.my_uint8();

                        scdr << data.my_short();

                        scdr << data.my_ushort();

                        scdr << data.my_longlong();

                        scdr << data.my_ulonglong();

                        scdr << data.my_float();

                        scdr << data.my_double();

                        scdr << data.my_longdouble();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const InnerUnion& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case 0:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.first(), current_alignment);
                    break;

                case 1:
                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.second(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const InnerUnion& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case 0:
                    scdr << eprosima::fastcdr::MemberId(1) << data.first();
                    break;

                case 1:
                default:
                    scdr << eprosima::fastcdr::MemberId(2) << data.second();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        InnerUnion& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    int16_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case 0:
                                                    {
                                                        PrimitivesStruct first_value;
                                                        data.first(std::move(first_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                case 1:
                                                default:
                                                    {
                                                        int64_t second_value{0};
                                                        data.second(std::move(second_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case 0:
                                                    dcdr >> data.first();
                                                    break;

                                                case 1:
                                                default:
                                                    dcdr >> data.second();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ComplexUnion& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};

    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0), data._d(),
                    current_alignment);

    switch (data._d())
    {
                case 0:
                case 1:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                                data.third(), current_alignment);
                    break;

                default:
                    calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                                data.fourth(), current_alignment);
                    break;

    }

    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}


template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ComplexUnion& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr << eprosima::fastcdr::MemberId(0) << data._d();

    switch (data._d())
    {
                case 0:
                case 1:
                    scdr << eprosima::fastcdr::MemberId(1) << data.third();
                    break;

                default:
                    scdr << eprosima::fastcdr::MemberId(2) << data.fourth();
                    break;

    }

    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ComplexUnion& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                if (0 == mid.id)
                {
                    int16_t discriminator;
                    dcdr >> discriminator;

                    switch (discriminator)
                    {
                                                case 0:
                                                case 1:
                                                    {
                                                        int32_t third_value{0};
                                                        data.third(std::move(third_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                                                default:
                                                    {
                                                        InnerUnion fourth_value;
                                                        data.fourth(std::move(fourth_value));
                                                        data._d(discriminator);
                                                        break;
                                                    }

                    }
                }
                else
                {
                    switch (data._d())
                    {
                                                case 0:
                                                case 1:
                                                    dcdr >> data.third();
                                                    break;

                                                default:
                                                    dcdr >> data.fourth();
                                                    break;

                    }
                    ret_value = false;
                }
                return ret_value;
            });
}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const MyBitSet&,
        size_t& current_alignment)
{
    return calculator.calculate_serialized_size(std::bitset<30>{}, current_alignment);
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const MyBitSet& data)
{
    std::bitset<30> bitset;

        bitset <<= 12;
        bitset |= (data.d & 0xFFF);

        bitset <<= 10;
        bitset |= (data.c & 0x3FF);

        bitset <<= 4;

        bitset <<= 1;
        bitset |= (data.b & 0x1);

        bitset <<= 3;
        bitset |= (data.a & 0x7);


    scdr << bitset;
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& dcdr,
        MyBitSet& data)
{
    std::bitset<30> bitset;
    dcdr >> bitset;

        data.a = static_cast<uint8_t>(bitset.to_ullong() & 0x7);
        bitset >>= 3;

        data.b = static_cast<bool>(bitset.to_ullong() & 0x1);
        bitset >>= 1;

        bitset >>= 4;

        data.c = static_cast<uint16_t>(bitset.to_ullong() & 0x3FF);
        bitset >>= 10;

        data.d = static_cast<int16_t>(bitset.to_ullong() & 0xFFF);
        bitset >>= 12;

}

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const AllStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.my_bool(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.my_octet(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.my_char(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.my_wchar(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.my_long(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.my_ulong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.my_int8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.my_uint8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.my_short(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.my_ushort(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.my_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.my_ulonglong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.my_float(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.my_double(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.my_longdouble(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(15),
                data.my_string(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(16),
                data.my_wstring(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(17),
                data.my_bounded_string(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(18),
                data.my_bounded_wstring(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(19),
                data.my_enum(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(20),
                data.my_bitmask(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(21),
                data.my_aliased_struct(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(22),
                data.my_aliased_enum(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(23),
                data.my_aliased_bounded_string(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(24),
                data.my_recursive_alias(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(25),
                data.bitmask_sequence(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(26),
                data.enum_sequence(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(27),
                data.short_sequence(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(28),
                data.long_array(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(29),
                data.string_unbounded_map(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(30),
                data.string_alias_unbounded_map(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(31),
                data.short_long_map(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(32),
                data.inner_union(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(33),
                data.complex_union(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(34),
                data.my_bitset(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const AllStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.my_bool()
        << eprosima::fastcdr::MemberId(1) << data.my_octet()
        << eprosima::fastcdr::MemberId(2) << data.my_char()
        << eprosima::fastcdr::MemberId(3) << data.my_wchar()
        << eprosima::fastcdr::MemberId(4) << data.my_long()
        << eprosima::fastcdr::MemberId(5) << data.my_ulong()
        << eprosima::fastcdr::MemberId(6) << data.my_int8()
        << eprosima::fastcdr::MemberId(7) << data.my_uint8()
        << eprosima::fastcdr::MemberId(8) << data.my_short()
        << eprosima::fastcdr::MemberId(9) << data.my_ushort()
        << eprosima::fastcdr::MemberId(10) << data.my_longlong()
        << eprosima::fastcdr::MemberId(11) << data.my_ulonglong()
        << eprosima::fastcdr::MemberId(12) << data.my_float()
        << eprosima::fastcdr::MemberId(13) << data.my_double()
        << eprosima::fastcdr::MemberId(14) << data.my_longdouble()
        << eprosima::fastcdr::MemberId(15) << data.my_string()
        << eprosima::fastcdr::MemberId(16) << data.my_wstring()
        << eprosima::fastcdr::MemberId(17) << data.my_bounded_string()
        << eprosima::fastcdr::MemberId(18) << data.my_bounded_wstring()
        << eprosima::fastcdr::MemberId(19) << data.my_enum()
        << eprosima::fastcdr::MemberId(20) << data.my_bitmask()
        << eprosima::fastcdr::MemberId(21) << data.my_aliased_struct()
        << eprosima::fastcdr::MemberId(22) << data.my_aliased_enum()
        << eprosima::fastcdr::MemberId(23) << data.my_aliased_bounded_string()
        << eprosima::fastcdr::MemberId(24) << data.my_recursive_alias()
        << eprosima::fastcdr::MemberId(25) << data.bitmask_sequence()
        << eprosima::fastcdr::MemberId(26) << data.enum_sequence()
        << eprosima::fastcdr::MemberId(27) << data.short_sequence()
        << eprosima::fastcdr::MemberId(28) << data.long_array()
        << eprosima::fastcdr::MemberId(29) << data.string_unbounded_map()
        << eprosima::fastcdr::MemberId(30) << data.string_alias_unbounded_map()
        << eprosima::fastcdr::MemberId(31) << data.short_long_map()
        << eprosima::fastcdr::MemberId(32) << data.inner_union()
        << eprosima::fastcdr::MemberId(33) << data.complex_union()
        << eprosima::fastcdr::MemberId(34) << data.my_bitset()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        AllStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.my_bool();
                                            break;

                                        case 1:
                                                dcdr >> data.my_octet();
                                            break;

                                        case 2:
                                                dcdr >> data.my_char();
                                            break;

                                        case 3:
                                                dcdr >> data.my_wchar();
                                            break;

                                        case 4:
                                                dcdr >> data.my_long();
                                            break;

                                        case 5:
                                                dcdr >> data.my_ulong();
                                            break;

                                        case 6:
                                                dcdr >> data.my_int8();
                                            break;

                                        case 7:
                                                dcdr >> data.my_uint8();
                                            break;

                                        case 8:
                                                dcdr >> data.my_short();
                                            break;

                                        case 9:
                                                dcdr >> data.my_ushort();
                                            break;

                                        case 10:
                                                dcdr >> data.my_longlong();
                                            break;

                                        case 11:
                                                dcdr >> data.my_ulonglong();
                                            break;

                                        case 12:
                                                dcdr >> data.my_float();
                                            break;

                                        case 13:
                                                dcdr >> data.my_double();
                                            break;

                                        case 14:
                                                dcdr >> data.my_longdouble();
                                            break;

                                        case 15:
                                                dcdr >> data.my_string();
                                            break;

                                        case 16:
                                                dcdr >> data.my_wstring();
                                            break;

                                        case 17:
                                                dcdr >> data.my_bounded_string();
                                            break;

                                        case 18:
                                                dcdr >> data.my_bounded_wstring();
                                            break;

                                        case 19:
                                                dcdr >> data.my_enum();
                                            break;

                                        case 20:
                                                dcdr >> data.my_bitmask();
                                            break;

                                        case 21:
                                                dcdr >> data.my_aliased_struct();
                                            break;

                                        case 22:
                                                dcdr >> data.my_aliased_enum();
                                            break;

                                        case 23:
                                                dcdr >> data.my_aliased_bounded_string();
                                            break;

                                        case 24:
                                                dcdr >> data.my_recursive_alias();
                                            break;

                                        case 25:
                                                dcdr >> data.bitmask_sequence();
                                            break;

                                        case 26:
                                                dcdr >> data.enum_sequence();
                                            break;

                                        case 27:
                                                dcdr >> data.short_sequence();
                                            break;

                                        case 28:
                                                dcdr >> data.long_array();
                                            break;

                                        case 29:
                                                dcdr >> data.string_unbounded_map();
                                            break;

                                        case 30:
                                                dcdr >> data.string_alias_unbounded_map();
                                            break;

                                        case 31:
                                                dcdr >> data.short_long_map();
                                            break;

                                        case 32:
                                                dcdr >> data.inner_union();
                                            break;

                                        case 33:
                                                dcdr >> data.complex_union();
                                            break;

                                        case 34:
                                                dcdr >> data.my_bitset();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AllStruct& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const PrimitivesStruct& data);
    serialize_key(scdr, static_cast<const PrimitivesStruct&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ComprehensiveType& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.index(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.inner_struct(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.complex_sequence(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.complex_array(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.complex_map(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ComprehensiveType& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.index()
        << eprosima::fastcdr::MemberId(1) << data.inner_struct()
        << eprosima::fastcdr::MemberId(2) << data.complex_sequence()
        << eprosima::fastcdr::MemberId(3) << data.complex_array()
        << eprosima::fastcdr::MemberId(4) << data.complex_map()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ComprehensiveType& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.index();
                                            break;

                                        case 1:
                                                dcdr >> data.inner_struct();
                                            break;

                                        case 2:
                                                dcdr >> data.complex_sequence();
                                            break;

                                        case 3:
                                                dcdr >> data.complex_array();
                                            break;

                                        case 4:
                                                dcdr >> data.complex_map();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ComprehensiveType& data)
{
            extern void serialize_key(
                    Cdr& scdr,
                    const AllStruct& data);





    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.index();

                        serialize_key(scdr, data.inner_struct());

                        scdr << data.complex_sequence();

                        scdr << data.complex_array();

                        scdr << data.complex_map();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__COMPREHENSIVETYPECDRAUX_IPP

