#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Adjust speech pitch (voice height)"

    def run(self):
        try:
            # Get current pitch
            current_pitch = float(
                self.env["runtime"]["SettingsManager"].get_setting(
                    "speech", "pitch"
                )
            )
        except Exception as e:
            current_pitch = 0.5

        # Present current pitch
        pitch_percent = int(current_pitch * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Current speech pitch: {pitch_percent} percent", interrupt=True
        )

        # Increase by 10%, wrap around if at max
        new_pitch = current_pitch + 0.1
        if new_pitch > 1.0:
            new_pitch = 0.1  # Wrap to minimum

        # Apply the new pitch
        self.env["runtime"]["SettingsManager"].set_setting(
            "speech", "pitch", str(new_pitch)
        )

        new_percent = int(new_pitch * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Speech pitch set to {new_percent} percent", interrupt=True
        )
        self.env["runtime"]["OutputManager"].play_sound("Accept")

    def set_callback(self, callback):
        pass
