/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * *****************************************************************************
 * This specific code is a port to C++ of the Envemind Python code by Radzinski
 * and colleagues of IsoSpec fame (Lacki, Startek and company :-)
 *
 * See https://github.com/PiotrRadzinski/envemind.
 * *****************************************************************************
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
#include <QDebug>
#include <QTcpServer>
#include <QTcpSocket>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassCore
{

class DECLSPEC MassDataServer: public QTcpServer
{
  Q_OBJECT

  public:
  MassDataServer(QObject *parent = nullptr);
  virtual ~MassDataServer();

  bool start();

  QString getIpAddress() const;
  int getPortNumber() const;

  void serveData(const QByteArray &byte_array_to_serve);

  bool hasReadyClient() const;

  signals:
  void writtenDataSignal(std::size_t written_bytes);

  protected:
  virtual void incomingConnection(qintptr socketDescriptor) override;

  protected:
  QString m_ipAddress;
  int m_portNumber;

  QList<QTcpSocket *> m_clients;
  QSet<QTcpSocket *> m_readyClients;


  void error(QTcpSocket::SocketError socket_error);
};

} // namespace libXpertMassCore

} // namespace MsXpS
